@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.features.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property approvalType The feature approval type.
 * @property authorizationProfile Authorization Profile
 * @property description The feature description.
 * @property displayName The featureDisplayName.
 * @property documentationLink The feature documentation link.
 * @property featureName The featureName.
 * @property metadata Key-value pairs for meta data.
 * @property providerNamespace The providerNamespace.
 * @property registrationDate The feature registration date.
 * @property releaseDate The feature release date.
 * @property shouldFeatureDisplayInPortal Indicates whether feature should be displayed in Portal.
 * @property state The state.
 * @property subscriptionId The subscriptionId.
 * @property tenantId The tenantId.
 */
public data class SubscriptionFeatureRegistrationResponseProperties(
    public val approvalType: String,
    public val authorizationProfile: AuthorizationProfileResponse? = null,
    public val description: String? = null,
    public val displayName: String,
    public val documentationLink: String,
    public val featureName: String,
    public val metadata: Map<String, String>? = null,
    public val providerNamespace: String,
    public val registrationDate: String,
    public val releaseDate: String,
    public val shouldFeatureDisplayInPortal: Boolean? = null,
    public val state: String? = null,
    public val subscriptionId: String,
    public val tenantId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.features.outputs.SubscriptionFeatureRegistrationResponseProperties):
            SubscriptionFeatureRegistrationResponseProperties =
            SubscriptionFeatureRegistrationResponseProperties(
                approvalType = javaType.approvalType(),
                authorizationProfile = javaType.authorizationProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.features.kotlin.outputs.AuthorizationProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                displayName = javaType.displayName(),
                documentationLink = javaType.documentationLink(),
                featureName = javaType.featureName(),
                metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                providerNamespace = javaType.providerNamespace(),
                registrationDate = javaType.registrationDate(),
                releaseDate = javaType.releaseDate(),
                shouldFeatureDisplayInPortal = javaType.shouldFeatureDisplayInPortal().map({ args0 ->
                    args0
                }).orElse(null),
                state = javaType.state().map({ args0 -> args0 }).orElse(null),
                subscriptionId = javaType.subscriptionId(),
                tenantId = javaType.tenantId(),
            )
    }
}
