@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin

import com.pulumi.azurenative.fluidrelay.FluidRelayServerArgs.builder
import com.pulumi.azurenative.fluidrelay.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.fluidrelay.kotlin.enums.StorageSKU
import com.pulumi.azurenative.fluidrelay.kotlin.inputs.EncryptionPropertiesArgs
import com.pulumi.azurenative.fluidrelay.kotlin.inputs.EncryptionPropertiesArgsBuilder
import com.pulumi.azurenative.fluidrelay.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.fluidrelay.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A FluidRelay Server.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2021-03-12-preview.
 * Other available API versions: 2021-06-15-preview.
 * ## Example Usage
 * ### Create a Fluid Relay server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fluidRelayServer = new AzureNative.FluidRelay.FluidRelayServer("fluidRelayServer", new()
 *     {
 *         FluidRelayServerName = "myFluidRelayServer",
 *         Identity = new AzureNative.FluidRelay.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.FluidRelay.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "west-us",
 *         ResourceGroup = "myResourceGroup",
 *         Storagesku = "basic",
 *         Tags =
 *         {
 *             { "Category", "sales" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/fluidrelay/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fluidrelay.NewFluidRelayServer(ctx, "fluidRelayServer", &fluidrelay.FluidRelayServerArgs{
 * 			FluidRelayServerName: pulumi.String("myFluidRelayServer"),
 * 			Identity: &fluidrelay.IdentityArgs{
 * 				Type: fluidrelay.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location:      pulumi.String("west-us"),
 * 			ResourceGroup: pulumi.String("myResourceGroup"),
 * 			Storagesku:    pulumi.String("basic"),
 * 			Tags: pulumi.StringMap{
 * 				"Category": pulumi.String("sales"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.fluidrelay.FluidRelayServer;
 * import com.pulumi.azurenative.fluidrelay.FluidRelayServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fluidRelayServer = new FluidRelayServer("fluidRelayServer", FluidRelayServerArgs.builder()
 *             .fluidRelayServerName("myFluidRelayServer")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("west-us")
 *             .resourceGroup("myResourceGroup")
 *             .storagesku("basic")
 *             .tags(Map.of("Category", "sales"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:fluidrelay:FluidRelayServer myFluidRelayServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.FluidRelay/fluidRelayServers/{fluidRelayServerName}
 * ```
 * @property encryption All encryption configuration for a resource.
 * @property fluidRelayServerName The Fluid Relay server resource name.
 * @property identity The type of identity used for the resource.
 * @property location The geo-location where the resource lives
 * @property provisioningState Provision states for FluidRelay RP
 * @property resourceGroup The resource group containing the resource.
 * @property storagesku Sku of the storage associated with the resource
 * @property tags Resource tags.
 */
public data class FluidRelayServerArgs(
    public val encryption: Output<EncryptionPropertiesArgs>? = null,
    public val fluidRelayServerName: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroup: Output<String>? = null,
    public val storagesku: Output<Either<String, StorageSKU>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.fluidrelay.FluidRelayServerArgs> {
    override fun toJava(): com.pulumi.azurenative.fluidrelay.FluidRelayServerArgs =
        com.pulumi.azurenative.fluidrelay.FluidRelayServerArgs.builder()
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fluidRelayServerName(fluidRelayServerName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .storagesku(
                storagesku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FluidRelayServerArgs].
 */
@PulumiTagMarker
public class FluidRelayServerArgsBuilder internal constructor() {
    private var encryption: Output<EncryptionPropertiesArgs>? = null

    private var fluidRelayServerName: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroup: Output<String>? = null

    private var storagesku: Output<Either<String, StorageSKU>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value All encryption configuration for a resource.
     */
    @JvmName("wemcepfigefoelst")
    public suspend fun encryption(`value`: Output<EncryptionPropertiesArgs>) {
        this.encryption = value
    }

    /**
     * @param value The Fluid Relay server resource name.
     */
    @JvmName("mwwiqtgcvnkwumsc")
    public suspend fun fluidRelayServerName(`value`: Output<String>) {
        this.fluidRelayServerName = value
    }

    /**
     * @param value The type of identity used for the resource.
     */
    @JvmName("ffgawgjjhwjamovx")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nyloprgjxgbbqnbh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Provision states for FluidRelay RP
     */
    @JvmName("labtygfvsucalbur")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The resource group containing the resource.
     */
    @JvmName("gjsiintgyeuwkhee")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Sku of the storage associated with the resource
     */
    @JvmName("nnkkyqbwtapfvovc")
    public suspend fun storagesku(`value`: Output<Either<String, StorageSKU>>) {
        this.storagesku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fgrryyifkoclbxyw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value All encryption configuration for a resource.
     */
    @JvmName("adidislddowfvyxm")
    public suspend fun encryption(`value`: EncryptionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument All encryption configuration for a resource.
     */
    @JvmName("layrlvjxsxjjvdyr")
    public suspend fun encryption(argument: suspend EncryptionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The Fluid Relay server resource name.
     */
    @JvmName("whythfstsyhmtkmm")
    public suspend fun fluidRelayServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fluidRelayServerName = mapped
    }

    /**
     * @param value The type of identity used for the resource.
     */
    @JvmName("eofjmchmhbyungbb")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The type of identity used for the resource.
     */
    @JvmName("jpvdhyhrfcpsntan")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kqwkengkvnoewqkm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Provision states for FluidRelay RP
     */
    @JvmName("lsdncdawwbdtkeun")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provision states for FluidRelay RP
     */
    @JvmName("hgonbqnvxljwbneo")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provision states for FluidRelay RP
     */
    @JvmName("fdybgctwfhhikpsw")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The resource group containing the resource.
     */
    @JvmName("vtbaljgypsfhvrph")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value Sku of the storage associated with the resource
     */
    @JvmName("ahdyqrpmyaabevsw")
    public suspend fun storagesku(`value`: Either<String, StorageSKU>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storagesku = mapped
    }

    /**
     * @param value Sku of the storage associated with the resource
     */
    @JvmName("rhytvlufknaavbku")
    public fun storagesku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageSKU>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storagesku = mapped
    }

    /**
     * @param value Sku of the storage associated with the resource
     */
    @JvmName("nlrrssloyataycwy")
    public fun storagesku(`value`: StorageSKU) {
        val toBeMapped = Either.ofRight<String, StorageSKU>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storagesku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pjauuwlwseenuybs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jgpfdulpbkadkxbx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FluidRelayServerArgs = FluidRelayServerArgs(
        encryption = encryption,
        fluidRelayServerName = fluidRelayServerName,
        identity = identity,
        location = location,
        provisioningState = provisioningState,
        resourceGroup = resourceGroup,
        storagesku = storagesku,
        tags = tags,
    )
}
