@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.graphservices.kotlin

import com.pulumi.azurenative.graphservices.kotlin.outputs.AccountResourceResponseProperties
import com.pulumi.azurenative.graphservices.kotlin.outputs.AccountResourceResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.graphservices.kotlin.outputs.AccountResourceResponseProperties.Companion.toKotlin as accountResourceResponsePropertiesToKotlin
import com.pulumi.azurenative.graphservices.kotlin.outputs.AccountResourceResponseSystemData.Companion.toKotlin as accountResourceResponseSystemDataToKotlin

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.azurenative.graphservices.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * Account details
 * Azure REST API version: 2023-04-13. Prior API version in Azure Native 1.x: 2022-09-22-preview.
 * ## Example Usage
 * ### Create Account resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.GraphServices.Account("account", new()
 *     {
 *         Properties = new AzureNative.GraphServices.Inputs.AccountResourcePropertiesArgs
 *         {
 *             AppId = "11111111-aaaa-1111-bbbb-111111111111",
 *         },
 *         ResourceGroupName = "testResourceGroupGRAM",
 *         ResourceName = "11111111-aaaa-1111-bbbb-1111111111111",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/graphservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := graphservices.NewAccount(ctx, "account", &graphservices.AccountArgs{
 * 			Properties: &graphservices.AccountResourcePropertiesArgs{
 * 				AppId: pulumi.String("11111111-aaaa-1111-bbbb-111111111111"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroupGRAM"),
 * 			ResourceName:      pulumi.String("11111111-aaaa-1111-bbbb-1111111111111"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.graphservices.Account;
 * import com.pulumi.azurenative.graphservices.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .properties(Map.of("appId", "11111111-aaaa-1111-bbbb-111111111111"))
 *             .resourceGroupName("testResourceGroupGRAM")
 *             .resourceName("11111111-aaaa-1111-bbbb-1111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:graphservices:Account 11111111-aaaa-1111-bbbb-111111111111 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.GraphServices/accounts/{resourceName}
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.azurenative.graphservices.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * Location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Property bag from billing account
     */
    public val properties: Output<AccountResourceResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                accountResourceResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<AccountResourceResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                accountResourceResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.graphservices.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.azurenative.graphservices.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit):
    Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
