@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Configuration setting of LCM (Local Configuration Manager).
 * @property actionAfterReboot Specifies what happens after a reboot during the application of a configuration. The possible values are ContinueConfiguration and StopConfiguration
 * @property allowModuleOverwrite If true - new configurations downloaded from the pull service are allowed to overwrite the old ones on the target node. Otherwise, false
 * @property configurationMode Specifies how the LCM(Local Configuration Manager) actually applies the configuration to the target nodes. Possible values are ApplyOnly, ApplyAndMonitor, and ApplyAndAutoCorrect.
 * @property configurationModeFrequencyMins How often, in minutes, the current configuration is checked and applied. This property is ignored if the ConfigurationMode property is set to ApplyOnly. The default value is 15.
 * @property rebootIfNeeded Set this to true to automatically reboot the node after a configuration that requires reboot is applied. Otherwise, you will have to manually reboot the node for any configuration that requires it. The default value is false. To use this setting when a reboot condition is enacted by something other than DSC (such as Windows Installer), combine this setting with the xPendingReboot module.
 * @property refreshFrequencyMins The time interval, in minutes, at which the LCM checks a pull service to get updated configurations. This value is ignored if the LCM is not configured in pull mode. The default value is 30.
 */
public data class ConfigurationSettingResponse(
    public val actionAfterReboot: String,
    public val allowModuleOverwrite: Boolean,
    public val configurationMode: String,
    public val configurationModeFrequencyMins: Double,
    public val rebootIfNeeded: Boolean,
    public val refreshFrequencyMins: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.ConfigurationSettingResponse):
            ConfigurationSettingResponse = ConfigurationSettingResponse(
            actionAfterReboot = javaType.actionAfterReboot(),
            allowModuleOverwrite = javaType.allowModuleOverwrite(),
            configurationMode = javaType.configurationMode(),
            configurationModeFrequencyMins = javaType.configurationModeFrequencyMins(),
            rebootIfNeeded = javaType.rebootIfNeeded(),
            refreshFrequencyMins = javaType.refreshFrequencyMins(),
        )
    }
}
