@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Guest configuration assignment is an association between a machine and guest configuration.
 * @property id ARM resource id of the guest configuration assignment.
 * @property location Region where the VM is located.
 * @property name Name of the guest configuration assignment.
 * @property properties Properties of the Guest configuration assignment.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource.
 */
public data class GetGuestConfigurationAssignmentsVMSSResult(
    public val id: String,
    public val location: String? = null,
    public val name: String? = null,
    public val properties: GuestConfigurationAssignmentPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.GetGuestConfigurationAssignmentsVMSSResult):
            GetGuestConfigurationAssignmentsVMSSResult = GetGuestConfigurationAssignmentsVMSSResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GuestConfigurationAssignmentPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.guestconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
