@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hanaonazure.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SapMonitor].
 */
@PulumiTagMarker
public class SapMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SapMonitorArgs = SapMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SapMonitorArgsBuilder.() -> Unit) {
        val builder = SapMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SapMonitor {
        val builtJavaResource = com.pulumi.azurenative.hanaonazure.SapMonitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SapMonitor(builtJavaResource)
    }
}

/**
 * SAP monitor info on Azure (ARM properties and SAP monitor properties)
 * Azure REST API version: 2020-02-07-preview. Prior API version in Azure Native 1.x: 2020-02-07-preview.
 * ## Example Usage
 * ### Create a SAP Monitor
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapMonitor = new AzureNative.HanaOnAzure.SapMonitor("sapMonitor", new()
 *     {
 *         EnableCustomerAnalytics = true,
 *         Location = "westus",
 *         LogAnalyticsWorkspaceArmId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace",
 *         LogAnalyticsWorkspaceId = "00000000-0000-0000-0000-000000000000",
 *         LogAnalyticsWorkspaceSharedKey = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000==",
 *         MonitorSubnet = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         ResourceGroupName = "myResourceGroup",
 *         SapMonitorName = "mySapMonitor",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hanaonazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hanaonazure.NewSapMonitor(ctx, "sapMonitor", &hanaonazure.SapMonitorArgs{
 * 			EnableCustomerAnalytics:        pulumi.Bool(true),
 * 			Location:                       pulumi.String("westus"),
 * 			LogAnalyticsWorkspaceArmId:     pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace"),
 * 			LogAnalyticsWorkspaceId:        pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			LogAnalyticsWorkspaceSharedKey: pulumi.String("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000=="),
 * 			MonitorSubnet:                  pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			ResourceGroupName:              pulumi.String("myResourceGroup"),
 * 			SapMonitorName:                 pulumi.String("mySapMonitor"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hanaonazure.SapMonitor;
 * import com.pulumi.azurenative.hanaonazure.SapMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapMonitor = new SapMonitor("sapMonitor", SapMonitorArgs.builder()
 *             .enableCustomerAnalytics(true)
 *             .location("westus")
 *             .logAnalyticsWorkspaceArmId("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace")
 *             .logAnalyticsWorkspaceId("00000000-0000-0000-0000-000000000000")
 *             .logAnalyticsWorkspaceSharedKey("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000==")
 *             .monitorSubnet("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet")
 *             .resourceGroupName("myResourceGroup")
 *             .sapMonitorName("mySapMonitor")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hanaonazure:SapMonitor myHanaInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}
 * ```
 */
public class SapMonitor internal constructor(
    override val javaResource: com.pulumi.azurenative.hanaonazure.SapMonitor,
) : KotlinCustomResource(javaResource, SapMonitorMapper) {
    /**
     * The value indicating whether to send analytics to Microsoft
     */
    public val enableCustomerAnalytics: Output<Boolean>?
        get() = javaResource.enableCustomerAnalytics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The ARM ID of the Log Analytics Workspace that is used for monitoring
     */
    public val logAnalyticsWorkspaceArmId: Output<String>?
        get() = javaResource.logAnalyticsWorkspaceArmId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The workspace ID of the log analytics workspace to be used for monitoring
     */
    public val logAnalyticsWorkspaceId: Output<String>?
        get() = javaResource.logAnalyticsWorkspaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The shared key of the log analytics workspace that is used for monitoring
     */
    public val logAnalyticsWorkspaceSharedKey: Output<String>?
        get() = javaResource.logAnalyticsWorkspaceSharedKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource group the SAP Monitor resources get deployed into.
     */
    public val managedResourceGroupName: Output<String>
        get() = javaResource.managedResourceGroupName().applyValue({ args0 -> args0 })

    /**
     * The subnet which the SAP monitor will be deployed in
     */
    public val monitorSubnet: Output<String>?
        get() = javaResource.monitorSubnet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of provisioning of the HanaInstance
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The version of the payload running in the Collector VM
     */
    public val sapMonitorCollectorVersion: Output<String>
        get() = javaResource.sapMonitorCollectorVersion().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SapMonitorMapper : ResourceMapper<SapMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hanaonazure.SapMonitor::class == javaResource::class

    override fun map(javaResource: Resource): SapMonitor = SapMonitor(
        javaResource as
            com.pulumi.azurenative.hanaonazure.SapMonitor,
    )
}

/**
 * @see [SapMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SapMonitor].
 */
public suspend fun sapMonitor(name: String, block: suspend SapMonitorResourceBuilder.() -> Unit):
    SapMonitor {
    val builder = SapMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SapMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sapMonitor(name: String): SapMonitor {
    val builder = SapMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
