@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hanaonazure.kotlin

import com.pulumi.azurenative.hanaonazure.SapMonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SAP monitor info on Azure (ARM properties and SAP monitor properties)
 * Azure REST API version: 2020-02-07-preview. Prior API version in Azure Native 1.x: 2020-02-07-preview.
 * ## Example Usage
 * ### Create a SAP Monitor
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapMonitor = new AzureNative.HanaOnAzure.SapMonitor("sapMonitor", new()
 *     {
 *         EnableCustomerAnalytics = true,
 *         Location = "westus",
 *         LogAnalyticsWorkspaceArmId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace",
 *         LogAnalyticsWorkspaceId = "00000000-0000-0000-0000-000000000000",
 *         LogAnalyticsWorkspaceSharedKey = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000==",
 *         MonitorSubnet = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         ResourceGroupName = "myResourceGroup",
 *         SapMonitorName = "mySapMonitor",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hanaonazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hanaonazure.NewSapMonitor(ctx, "sapMonitor", &hanaonazure.SapMonitorArgs{
 * 			EnableCustomerAnalytics:        pulumi.Bool(true),
 * 			Location:                       pulumi.String("westus"),
 * 			LogAnalyticsWorkspaceArmId:     pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace"),
 * 			LogAnalyticsWorkspaceId:        pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			LogAnalyticsWorkspaceSharedKey: pulumi.String("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000=="),
 * 			MonitorSubnet:                  pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			ResourceGroupName:              pulumi.String("myResourceGroup"),
 * 			SapMonitorName:                 pulumi.String("mySapMonitor"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hanaonazure.SapMonitor;
 * import com.pulumi.azurenative.hanaonazure.SapMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapMonitor = new SapMonitor("sapMonitor", SapMonitorArgs.builder()
 *             .enableCustomerAnalytics(true)
 *             .location("westus")
 *             .logAnalyticsWorkspaceArmId("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.operationalinsights/workspaces/myWorkspace")
 *             .logAnalyticsWorkspaceId("00000000-0000-0000-0000-000000000000")
 *             .logAnalyticsWorkspaceSharedKey("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000==")
 *             .monitorSubnet("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet")
 *             .resourceGroupName("myResourceGroup")
 *             .sapMonitorName("mySapMonitor")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hanaonazure:SapMonitor myHanaInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}
 * ```
 * @property enableCustomerAnalytics The value indicating whether to send analytics to Microsoft
 * @property location The geo-location where the resource lives
 * @property logAnalyticsWorkspaceArmId The ARM ID of the Log Analytics Workspace that is used for monitoring
 * @property logAnalyticsWorkspaceId The workspace ID of the log analytics workspace to be used for monitoring
 * @property logAnalyticsWorkspaceSharedKey The shared key of the log analytics workspace that is used for monitoring
 * @property monitorSubnet The subnet which the SAP monitor will be deployed in
 * @property resourceGroupName Name of the resource group.
 * @property sapMonitorName Name of the SAP monitor resource.
 * @property tags Resource tags.
 */
public data class SapMonitorArgs(
    public val enableCustomerAnalytics: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val logAnalyticsWorkspaceArmId: Output<String>? = null,
    public val logAnalyticsWorkspaceId: Output<String>? = null,
    public val logAnalyticsWorkspaceSharedKey: Output<String>? = null,
    public val monitorSubnet: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sapMonitorName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hanaonazure.SapMonitorArgs> {
    override fun toJava(): com.pulumi.azurenative.hanaonazure.SapMonitorArgs =
        com.pulumi.azurenative.hanaonazure.SapMonitorArgs.builder()
            .enableCustomerAnalytics(enableCustomerAnalytics?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .logAnalyticsWorkspaceArmId(logAnalyticsWorkspaceArmId?.applyValue({ args0 -> args0 }))
            .logAnalyticsWorkspaceId(logAnalyticsWorkspaceId?.applyValue({ args0 -> args0 }))
            .logAnalyticsWorkspaceSharedKey(logAnalyticsWorkspaceSharedKey?.applyValue({ args0 -> args0 }))
            .monitorSubnet(monitorSubnet?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sapMonitorName(sapMonitorName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SapMonitorArgs].
 */
@PulumiTagMarker
public class SapMonitorArgsBuilder internal constructor() {
    private var enableCustomerAnalytics: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var logAnalyticsWorkspaceArmId: Output<String>? = null

    private var logAnalyticsWorkspaceId: Output<String>? = null

    private var logAnalyticsWorkspaceSharedKey: Output<String>? = null

    private var monitorSubnet: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sapMonitorName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The value indicating whether to send analytics to Microsoft
     */
    @JvmName("xmtkosqpxpqymdve")
    public suspend fun enableCustomerAnalytics(`value`: Output<Boolean>) {
        this.enableCustomerAnalytics = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hmlprbjqgtlfejxk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The ARM ID of the Log Analytics Workspace that is used for monitoring
     */
    @JvmName("segeuvhcrquhktcf")
    public suspend fun logAnalyticsWorkspaceArmId(`value`: Output<String>) {
        this.logAnalyticsWorkspaceArmId = value
    }

    /**
     * @param value The workspace ID of the log analytics workspace to be used for monitoring
     */
    @JvmName("yiyfckcxpkqambmm")
    public suspend fun logAnalyticsWorkspaceId(`value`: Output<String>) {
        this.logAnalyticsWorkspaceId = value
    }

    /**
     * @param value The shared key of the log analytics workspace that is used for monitoring
     */
    @JvmName("dvlhnlcwmcisxovo")
    public suspend fun logAnalyticsWorkspaceSharedKey(`value`: Output<String>) {
        this.logAnalyticsWorkspaceSharedKey = value
    }

    /**
     * @param value The subnet which the SAP monitor will be deployed in
     */
    @JvmName("ljbnltvsxqignjfs")
    public suspend fun monitorSubnet(`value`: Output<String>) {
        this.monitorSubnet = value
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("htpwiplyyrxlaynm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("txiyexkumfarxeqy")
    public suspend fun sapMonitorName(`value`: Output<String>) {
        this.sapMonitorName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ipwdynfjsjfjaiwi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The value indicating whether to send analytics to Microsoft
     */
    @JvmName("xgxybujqhibtlpea")
    public suspend fun enableCustomerAnalytics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCustomerAnalytics = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("redlunoxcgjoikqw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The ARM ID of the Log Analytics Workspace that is used for monitoring
     */
    @JvmName("dxbxhwsliayxlxic")
    public suspend fun logAnalyticsWorkspaceArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsWorkspaceArmId = mapped
    }

    /**
     * @param value The workspace ID of the log analytics workspace to be used for monitoring
     */
    @JvmName("jmbnpemmfphpnhib")
    public suspend fun logAnalyticsWorkspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsWorkspaceId = mapped
    }

    /**
     * @param value The shared key of the log analytics workspace that is used for monitoring
     */
    @JvmName("nvebrlgdysikjeod")
    public suspend fun logAnalyticsWorkspaceSharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsWorkspaceSharedKey = mapped
    }

    /**
     * @param value The subnet which the SAP monitor will be deployed in
     */
    @JvmName("vchumehwjivugqfq")
    public suspend fun monitorSubnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorSubnet = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("bevsrmmhavrxagpm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("hcmabowoiduuqkdv")
    public suspend fun sapMonitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapMonitorName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oskeqcsjpoxngryc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bqxbnhundiappkas")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SapMonitorArgs = SapMonitorArgs(
        enableCustomerAnalytics = enableCustomerAnalytics,
        location = location,
        logAnalyticsWorkspaceArmId = logAnalyticsWorkspaceArmId,
        logAnalyticsWorkspaceId = logAnalyticsWorkspaceId,
        logAnalyticsWorkspaceSharedKey = logAnalyticsWorkspaceSharedKey,
        monitorSubnet = monitorSubnet,
        resourceGroupName = resourceGroupName,
        sapMonitorName = sapMonitorName,
        tags = tags,
    )
}
