@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin

import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterArgs.builder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.CloudHsmClusterSecurityDomainPropertiesArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.CloudHsmClusterSecurityDomainPropertiesArgsBuilder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.CloudHsmClusterSkuArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.CloudHsmClusterSkuArgsBuilder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.CloudHsmPropertiesArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.CloudHsmPropertiesArgsBuilder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.PrivateEndpointConnectionArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.PrivateEndpointConnectionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource information with extended details.
 * Azure REST API version: 2022-08-31-preview.
 * Other available API versions: 2023-12-10-preview.
 * ## Example Usage
 * ### CloudHsmCluster_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudHsmCluster = new AzureNative.HardwareSecurityModules.CloudHsmCluster("cloudHsmCluster", new()
 *     {
 *         CloudHsmClusterName = "chsm1",
 *         Location = "eastus2",
 *         ResourceGroupName = "rgcloudhsm",
 *         SecurityDomain = new AzureNative.HardwareSecurityModules.Inputs.CloudHsmClusterSecurityDomainPropertiesArgs
 *         {
 *             FipsState = 2,
 *         },
 *         Sku = new AzureNative.HardwareSecurityModules.Inputs.CloudHsmClusterSkuArgs
 *         {
 *             Family = "B",
 *             Name = AzureNative.HardwareSecurityModules.CloudHsmClusterSkuName.Standard_B1,
 *         },
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewCloudHsmCluster(ctx, "cloudHsmCluster", &hardwaresecuritymodules.CloudHsmClusterArgs{
 * 			CloudHsmClusterName: pulumi.String("chsm1"),
 * 			Location:            pulumi.String("eastus2"),
 * 			ResourceGroupName:   pulumi.String("rgcloudhsm"),
 * 			SecurityDomain: &hardwaresecuritymodules.CloudHsmClusterSecurityDomainPropertiesArgs{
 * 				FipsState: pulumi.Int(2),
 * 			},
 * 			Sku: &hardwaresecuritymodules.CloudHsmClusterSkuArgs{
 * 				Family: pulumi.String("B"),
 * 				Name:   hardwaresecuritymodules.CloudHsmClusterSkuName_Standard_B1,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmCluster;
 * import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudHsmCluster = new CloudHsmCluster("cloudHsmCluster", CloudHsmClusterArgs.builder()
 *             .cloudHsmClusterName("chsm1")
 *             .location("eastus2")
 *             .resourceGroupName("rgcloudhsm")
 *             .securityDomain(Map.of("fipsState", 2))
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "B"),
 *                 Map.entry("name", "Standard_B1")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hardwaresecuritymodules:CloudHsmCluster chsm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}
 * ```
 * @property autoGeneratedDomainNameLabelScope The Cloud HSM Cluster's auto-generated Domain Name Label Scope
 * @property cloudHsmClusterName The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
 * @property hsms An array of Cloud HSM Cluster's HSMs
 * @property location The geo-location where the resource lives
 * @property privateEndpointConnections List of private endpoint connection resources
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property provisioningState The Cloud HSM Cluster's provisioningState
 * @property publicNetworkAccess The Cloud HSM Cluster public network access
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityDomain Security domain properties information for Cloud HSM cluster
 * @property sku SKU details
 * @property tags Resource tags.
 */
public data class CloudHsmClusterArgs(
    public val autoGeneratedDomainNameLabelScope: Output<String>? = null,
    public val cloudHsmClusterName: Output<String>? = null,
    public val hsms: Output<List<CloudHsmPropertiesArgs>>? = null,
    public val location: Output<String>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityDomain: Output<CloudHsmClusterSecurityDomainPropertiesArgs>? = null,
    public val sku: Output<CloudHsmClusterSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterArgs.builder()
            .autoGeneratedDomainNameLabelScope(
                autoGeneratedDomainNameLabelScope?.applyValue({ args0 ->
                    args0
                }),
            )
            .cloudHsmClusterName(cloudHsmClusterName?.applyValue({ args0 -> args0 }))
            .hsms(hsms?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityDomain(securityDomain?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CloudHsmClusterArgs].
 */
@PulumiTagMarker
public class CloudHsmClusterArgsBuilder internal constructor() {
    private var autoGeneratedDomainNameLabelScope: Output<String>? = null

    private var cloudHsmClusterName: Output<String>? = null

    private var hsms: Output<List<CloudHsmPropertiesArgs>>? = null

    private var location: Output<String>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityDomain: Output<CloudHsmClusterSecurityDomainPropertiesArgs>? = null

    private var sku: Output<CloudHsmClusterSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Cloud HSM Cluster's auto-generated Domain Name Label Scope
     */
    @JvmName("klobvtbhpdxsfndv")
    public suspend fun autoGeneratedDomainNameLabelScope(`value`: Output<String>) {
        this.autoGeneratedDomainNameLabelScope = value
    }

    /**
     * @param value The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
     */
    @JvmName("pbrsijnfgqaeqrfq")
    public suspend fun cloudHsmClusterName(`value`: Output<String>) {
        this.cloudHsmClusterName = value
    }

    /**
     * @param value An array of Cloud HSM Cluster's HSMs
     */
    @JvmName("bplfhpjixinvcgcl")
    public suspend fun hsms(`value`: Output<List<CloudHsmPropertiesArgs>>) {
        this.hsms = value
    }

    @JvmName("wubbjamprtxibehg")
    public suspend fun hsms(vararg values: Output<CloudHsmPropertiesArgs>) {
        this.hsms = Output.all(values.asList())
    }

    /**
     * @param values An array of Cloud HSM Cluster's HSMs
     */
    @JvmName("etbvselpeobgkewo")
    public suspend fun hsms(values: List<Output<CloudHsmPropertiesArgs>>) {
        this.hsms = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bpmpfispwlgapmlc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of private endpoint connection resources
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xqdnukdvojgitgdb")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("krroxpgfvhefvsxr")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values List of private endpoint connection resources
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pxdabcecklfehdqk")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value The Cloud HSM Cluster's provisioningState
     */
    @JvmName("mmqplsatyrawtlrr")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The Cloud HSM Cluster public network access
     */
    @JvmName("bdutflrdtvsetoxs")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ayjlwvmdqyysnhjl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Security domain properties information for Cloud HSM cluster
     */
    @JvmName("vontrwqshtufxcme")
    public suspend fun securityDomain(`value`: Output<CloudHsmClusterSecurityDomainPropertiesArgs>) {
        this.securityDomain = value
    }

    /**
     * @param value SKU details
     */
    @JvmName("ohgukcawkkrblqwe")
    public suspend fun sku(`value`: Output<CloudHsmClusterSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bidbbbqfpacbfueu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Cloud HSM Cluster's auto-generated Domain Name Label Scope
     */
    @JvmName("esseqoydkmjwoqie")
    public suspend fun autoGeneratedDomainNameLabelScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
     */
    @JvmName("riwsryvybphkfsbn")
    public suspend fun cloudHsmClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudHsmClusterName = mapped
    }

    /**
     * @param value An array of Cloud HSM Cluster's HSMs
     */
    @JvmName("dglgrpefotcsstqk")
    public suspend fun hsms(`value`: List<CloudHsmPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsms = mapped
    }

    /**
     * @param argument An array of Cloud HSM Cluster's HSMs
     */
    @JvmName("ierldqwggrtugqqr")
    public suspend fun hsms(argument: List<suspend CloudHsmPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CloudHsmPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hsms = mapped
    }

    /**
     * @param argument An array of Cloud HSM Cluster's HSMs
     */
    @JvmName("guyfjwejffmwplxr")
    public suspend fun hsms(vararg argument: suspend CloudHsmPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CloudHsmPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hsms = mapped
    }

    /**
     * @param argument An array of Cloud HSM Cluster's HSMs
     */
    @JvmName("pnvcydcuprikhmoq")
    public suspend fun hsms(argument: suspend CloudHsmPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CloudHsmPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.hsms = mapped
    }

    /**
     * @param values An array of Cloud HSM Cluster's HSMs
     */
    @JvmName("ndfoujtvccpetcmt")
    public suspend fun hsms(vararg values: CloudHsmPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hsms = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rcxotvjqmqjwtsol")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of private endpoint connection resources
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("qgjxqlyxsvaokttg")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of private endpoint connection resources
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bsqwvmgkkvfingsk")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of private endpoint connection resources
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("niadenwjscjcfvcc")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of private endpoint connection resources
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("lchofyhcshxvywnu")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values List of private endpoint connection resources
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jxdkvdytowsrjmmg")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value The Cloud HSM Cluster's provisioningState
     */
    @JvmName("xvdflaeawnwjofmf")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The Cloud HSM Cluster's provisioningState
     */
    @JvmName("yyeyfeffqmkmekuf")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The Cloud HSM Cluster's provisioningState
     */
    @JvmName("puxwcmutdelmwcvl")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The Cloud HSM Cluster public network access
     */
    @JvmName("hqaftywbyfmgswdw")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hfyeifadjnvesneg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Security domain properties information for Cloud HSM cluster
     */
    @JvmName("qxobospgittkrifa")
    public suspend fun securityDomain(`value`: CloudHsmClusterSecurityDomainPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityDomain = mapped
    }

    /**
     * @param argument Security domain properties information for Cloud HSM cluster
     */
    @JvmName("mlfjxvcjgjveoxcw")
    public suspend
    fun securityDomain(argument: suspend CloudHsmClusterSecurityDomainPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CloudHsmClusterSecurityDomainPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.securityDomain = mapped
    }

    /**
     * @param value SKU details
     */
    @JvmName("xygfdcvdovnntqpc")
    public suspend fun sku(`value`: CloudHsmClusterSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU details
     */
    @JvmName("jfoqckbdghaxoeqa")
    public suspend fun sku(argument: suspend CloudHsmClusterSkuArgsBuilder.() -> Unit) {
        val toBeMapped = CloudHsmClusterSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sqnmjosikysaokyq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ushfjulrrdgfbcib")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CloudHsmClusterArgs = CloudHsmClusterArgs(
        autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope,
        cloudHsmClusterName = cloudHsmClusterName,
        hsms = hsms,
        location = location,
        privateEndpointConnections = privateEndpointConnections,
        provisioningState = provisioningState,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        securityDomain = securityDomain,
        sku = sku,
        tags = tags,
    )
}
