@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs

import com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmClusterSkuArgs.builder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.enums.CloudHsmClusterSkuFamily
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.enums.CloudHsmClusterSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cloud Hsm Cluster SKU information
 * @property capacity Sku capacity
 * @property family Sku family of the Cloud HSM Cluster
 * @property name Sku name of the Cloud HSM Cluster
 */
public data class CloudHsmClusterSkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<Either<String, CloudHsmClusterSkuFamily>>,
    public val name: Output<CloudHsmClusterSkuName>,
) : ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmClusterSkuArgs> {
    override fun toJava():
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmClusterSkuArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmClusterSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(
                family.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CloudHsmClusterSkuArgs].
 */
@PulumiTagMarker
public class CloudHsmClusterSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<Either<String, CloudHsmClusterSkuFamily>>? = null

    private var name: Output<CloudHsmClusterSkuName>? = null

    /**
     * @param value Sku capacity
     */
    @JvmName("noqajobwubadseld")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Sku family of the Cloud HSM Cluster
     */
    @JvmName("ueroqwdyymvucgog")
    public suspend fun family(`value`: Output<Either<String, CloudHsmClusterSkuFamily>>) {
        this.family = value
    }

    /**
     * @param value Sku name of the Cloud HSM Cluster
     */
    @JvmName("eltlmandfeuqqnxf")
    public suspend fun name(`value`: Output<CloudHsmClusterSkuName>) {
        this.name = value
    }

    /**
     * @param value Sku capacity
     */
    @JvmName("jrvdmwypxnaqrkmh")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Sku family of the Cloud HSM Cluster
     */
    @JvmName("hwurtmrcojnhgatt")
    public suspend fun family(`value`: Either<String, CloudHsmClusterSkuFamily>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Sku family of the Cloud HSM Cluster
     */
    @JvmName("rfambsgvkcehvvbv")
    public fun family(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CloudHsmClusterSkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Sku family of the Cloud HSM Cluster
     */
    @JvmName("jwhngdkxmlcvjqih")
    public fun family(`value`: CloudHsmClusterSkuFamily) {
        val toBeMapped = Either.ofRight<String, CloudHsmClusterSkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Sku name of the Cloud HSM Cluster
     */
    @JvmName("uvhnaundowcbwuyu")
    public suspend fun name(`value`: CloudHsmClusterSkuName) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CloudHsmClusterSkuArgs = CloudHsmClusterSkuArgs(
        capacity = capacity,
        family = family ?: throw PulumiNullFieldException("family"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
