@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs

import com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetDedicatedHsmPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the dedicated HSM.
 * @property resourceGroupName The name of the Resource Group to which the dedicated hsm belongs.
 */
public data class GetDedicatedHsmPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetDedicatedHsmPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetDedicatedHsmPlainArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetDedicatedHsmPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedHsmPlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedHsmPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the dedicated HSM.
     */
    @JvmName("tckdjvihwsmaaxti")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the Resource Group to which the dedicated hsm belongs.
     */
    @JvmName("igpakxsxqmxvvrtq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDedicatedHsmPlainArgs = GetDedicatedHsmPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
