@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs

import com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The network interface definition.
 * @property privateIpAddress Private Ip address of the interface
 */
public data class NetworkInterfaceArgs(
    public val privateIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkInterfaceArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkInterfaceArgs.builder()
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceArgsBuilder internal constructor() {
    private var privateIpAddress: Output<String>? = null

    /**
     * @param value Private Ip address of the interface
     */
    @JvmName("mqgqwjubhojcomty")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value Private Ip address of the interface
     */
    @JvmName("pirjshhjvqbjuogr")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    internal fun build(): NetworkInterfaceArgs = NetworkInterfaceArgs(
        privateIpAddress = privateIpAddress,
    )
}
