@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Security domain properties information for Cloud HSM cluster
 * @property activationStatus status of security domain activation
 * @property fipsState FIPS state information for security domain
 */
public data class CloudHsmClusterSecurityDomainPropertiesResponse(
    public val activationStatus: String? = null,
    public val fipsState: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hardwaresecuritymodules.outputs.CloudHsmClusterSecurityDomainPropertiesResponse):
            CloudHsmClusterSecurityDomainPropertiesResponse =
            CloudHsmClusterSecurityDomainPropertiesResponse(
                activationStatus = javaType.activationStatus().map({ args0 -> args0 }).orElse(null),
                fipsState = javaType.fipsState().map({ args0 -> args0 }).orElse(null),
            )
    }
}
