@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin

import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterGetPropertiesResponse
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterIdentityResponse
import com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterGetPropertiesResponse.Companion.toKotlin as clusterGetPropertiesResponseToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterIdentityResponse.Companion.toKotlin as clusterIdentityResponseToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.azurenative.hdinsight.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * The HDInsight cluster.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * Other available API versions: 2023-04-15-preview, 2023-06-01-preview, 2023-08-15-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Create HDInsight cluster with Autoscale configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 ComponentVersion =
 *                 {
 *                     { "Hadoop", "2.7" },
 *                 },
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         AutoscaleConfiguration = new AzureNative.HDInsight.Inputs.AutoscaleArgs
 *                         {
 *                             Recurrence = new AzureNative.HDInsight.Inputs.AutoscaleRecurrenceArgs
 *                             {
 *                                 Schedule = new[]
 *                                 {
 *                                     new AzureNative.HDInsight.Inputs.AutoscaleScheduleArgs
 *                                     {
 *                                         Days = new[]
 *                                         {
 *                                             "Monday",
 *                                             "Tuesday",
 *                                             "Wednesday",
 *                                             "Thursday",
 *                                             "Friday",
 *                                         },
 *                                         TimeAndCapacity = new AzureNative.HDInsight.Inputs.AutoscaleTimeAndCapacityArgs
 *                                         {
 *                                             MaxInstanceCount = 3,
 *                                             MinInstanceCount = 3,
 *                                             Time = "09:00",
 *                                         },
 *                                     },
 *                                     new AzureNative.HDInsight.Inputs.AutoscaleScheduleArgs
 *                                     {
 *                                         Days = new[]
 *                                         {
 *                                             "Monday",
 *                                             "Tuesday",
 *                                             "Wednesday",
 *                                             "Thursday",
 *                                             "Friday",
 *                                         },
 *                                         TimeAndCapacity = new AzureNative.HDInsight.Inputs.AutoscaleTimeAndCapacityArgs
 *                                         {
 *                                             MaxInstanceCount = 6,
 *                                             MinInstanceCount = 6,
 *                                             Time = "18:00",
 *                                         },
 *                                     },
 *                                     new AzureNative.HDInsight.Inputs.AutoscaleScheduleArgs
 *                                     {
 *                                         Days = new[]
 *                                         {
 *                                             "Saturday",
 *                                             "Sunday",
 *                                         },
 *                                         TimeAndCapacity = new AzureNative.HDInsight.Inputs.AutoscaleTimeAndCapacityArgs
 *                                         {
 *                                             MaxInstanceCount = 2,
 *                                             MinInstanceCount = 2,
 *                                             Time = "09:00",
 *                                         },
 *                                     },
 *                                     new AzureNative.HDInsight.Inputs.AutoscaleScheduleArgs
 *                                     {
 *                                         Days = new[]
 *                                         {
 *                                             "Saturday",
 *                                             "Sunday",
 *                                         },
 *                                         TimeAndCapacity = new AzureNative.HDInsight.Inputs.AutoscaleTimeAndCapacityArgs
 *                                         {
 *                                             MaxInstanceCount = 4,
 *                                             MinInstanceCount = 4,
 *                                             Time = "18:00",
 *                                         },
 *                                     },
 *                                 },
 *                                 TimeZone = "China Standard Time",
 *                             },
 *                         },
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D4_V2",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         ScriptActions = new[] {},
 *                         TargetInstanceCount = 4,
 *                     },
 *                 },
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "hdinsight-autoscale-tes-2019-06-18t05-49-16-591z",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Standard",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * ComponentVersion: pulumi.StringMap{
 * "Hadoop": pulumi.String("2.7"),
 * },
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.6"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * AutoscaleConfiguration: interface{}{
 * Recurrence: interface{}{
 * Schedule: hdinsight.AutoscaleScheduleArray{
 * interface{}{
 * Days: pulumi.StringArray{
 * pulumi.String("Monday"),
 * pulumi.String("Tuesday"),
 * pulumi.String("Wednesday"),
 * pulumi.String("Thursday"),
 * pulumi.String("Friday"),
 * },
 * TimeAndCapacity: &hdinsight.AutoscaleTimeAndCapacityArgs{
 * MaxInstanceCount: pulumi.Int(3),
 * MinInstanceCount: pulumi.Int(3),
 * Time: pulumi.String("09:00"),
 * },
 * },
 * interface{}{
 * Days: pulumi.StringArray{
 * pulumi.String("Monday"),
 * pulumi.String("Tuesday"),
 * pulumi.String("Wednesday"),
 * pulumi.String("Thursday"),
 * pulumi.String("Friday"),
 * },
 * TimeAndCapacity: &hdinsight.AutoscaleTimeAndCapacityArgs{
 * MaxInstanceCount: pulumi.Int(6),
 * MinInstanceCount: pulumi.Int(6),
 * Time: pulumi.String("18:00"),
 * },
 * },
 * interface{}{
 * Days: pulumi.StringArray{
 * pulumi.String("Saturday"),
 * pulumi.String("Sunday"),
 * },
 * TimeAndCapacity: &hdinsight.AutoscaleTimeAndCapacityArgs{
 * MaxInstanceCount: pulumi.Int(2),
 * MinInstanceCount: pulumi.Int(2),
 * Time: pulumi.String("09:00"),
 * },
 * },
 * interface{}{
 * Days: pulumi.StringArray{
 * pulumi.String("Saturday"),
 * pulumi.String("Sunday"),
 * },
 * TimeAndCapacity: &hdinsight.AutoscaleTimeAndCapacityArgs{
 * MaxInstanceCount: pulumi.Int(4),
 * MinInstanceCount: pulumi.Int(4),
 * Time: pulumi.String("18:00"),
 * },
 * },
 * },
 * TimeZone: pulumi.String("China Standard Time"),
 * },
 * },
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D4_V2"),
 * },
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * ScriptActions: hdinsight.ScriptActionArray{
 * },
 * TargetInstanceCount: pulumi.Int(4),
 * },
 * },
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("hdinsight-autoscale-tes-2019-06-18t05-49-16-591z"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storagekey"),
 * Name: pulumi.String("mystorage.blob.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Standard"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("componentVersion", Map.of("Hadoop", "2.7")),
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.6"),
 *                     Map.entry("computeProfile", Map.of("roles", Map.ofEntries(
 *                         Map.entry("autoscaleConfiguration", Map.of("recurrence", Map.ofEntries(
 *                             Map.entry("schedule",
 *                                 Map.ofEntries(
 *                                     Map.entry("days",
 *                                         "Monday",
 *                                         "Tuesday",
 *                                         "Wednesday",
 *                                         "Thursday",
 *                                         "Friday"),
 *                                     Map.entry("timeAndCapacity", Map.ofEntries(
 *                                         Map.entry("maxInstanceCount", 3),
 *                                         Map.entry("minInstanceCount", 3),
 *                                         Map.entry("time", "09:00")
 *                                     ))
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("days",
 *                                         "Monday",
 *                                         "Tuesday",
 *                                         "Wednesday",
 *                                         "Thursday",
 *                                         "Friday"),
 *                                     Map.entry("timeAndCapacity", Map.ofEntries(
 *                                         Map.entry("maxInstanceCount", 6),
 *                                         Map.entry("minInstanceCount", 6),
 *                                         Map.entry("time", "18:00")
 *                                     ))
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("days",
 *                                         "Saturday",
 *                                         "Sunday"),
 *                                     Map.entry("timeAndCapacity", Map.ofEntries(
 *                                         Map.entry("maxInstanceCount", 2),
 *                                         Map.entry("minInstanceCount", 2),
 *                                         Map.entry("time", "09:00")
 *                                     ))
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("days",
 *                                         "Saturday",
 *                                         "Sunday"),
 *                                     Map.entry("timeAndCapacity", Map.ofEntries(
 *                                         Map.entry("maxInstanceCount", 4),
 *                                         Map.entry("minInstanceCount", 4),
 *                                         Map.entry("time", "18:00")
 *                                     ))
 *                                 )),
 *                             Map.entry("timeZone", "China Standard Time")
 *                         ))),
 *                         Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D4_V2")),
 *                         Map.entry("name", "workernode"),
 *                         Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                             Map.entry("password", "**********"),
 *                             Map.entry("username", "sshuser")
 *                         ))),
 *                         Map.entry("scriptActions", ),
 *                         Map.entry("targetInstanceCount", 4)
 *                     ))),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "hdinsight-autoscale-tes-2019-06-18t05-49-16-591z"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storagekey"),
 *                         Map.entry("name", "mystorage.blob.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Standard")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .build());
 *         }
 * }
 * ```
 * ### Create Hadoop cluster with Azure Data Lake Storage Gen 2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", "true" },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 4,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         FileSystem = "default",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.dfs.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Standard",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": "true",
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("Hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.6"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D3_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D3_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(4),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Small"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("zookeepernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * },
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * FileSystem: pulumi.String("default"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storagekey"),
 * Name: pulumi.String("mystorage.dfs.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Standard"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "Hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.6"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D3_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D3_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 4)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Small")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "zookeepernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ))),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("fileSystem", "default"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storagekey"),
 *                         Map.entry("name", "mystorage.dfs.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Standard")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .tags(Map.of("key1", "val1"))
 *                 .build());
 *         }
 * }
 * ```
 * ### Create Hadoop on Linux cluster with SSH password
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", "true" },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.5",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 4,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Standard",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": "true",
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("Hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.5"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D3_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D3_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(4),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Small"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("zookeepernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * },
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("containername"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storagekey"),
 * Name: pulumi.String("mystorage.blob.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Standard"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "Hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.5"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D3_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D3_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 4)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Small")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "zookeepernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ))),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "containername"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storagekey"),
 *                         Map.entry("name", "mystorage.blob.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Standard")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .tags(Map.of("key1", "val1"))
 *                 .build());
 *         }
 * }
 * ```
 * ### Create Hadoop on Linux cluster with SSH public key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.5",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 4,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Standard",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("Hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.5"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D3_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D3_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(4),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Small"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("zookeepernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * },
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("containername"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storagekey"),
 * Name: pulumi.String("mystorage.blob.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Standard"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "Hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.5"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D3_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D3_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 4)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Small")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "zookeepernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ))),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "containername"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storagekey"),
 *                         Map.entry("name", "mystorage.blob.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Standard")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .tags(Map.of("key1", "val1"))
 *                 .build());
 *         }
 * }
 * ```
 * ### Create Kafka cluster with Kafka Rest Proxy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 ComponentVersion =
 *                 {
 *                     { "Kafka", "2.1" },
 *                 },
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "kafka",
 *             },
 *             ClusterVersion = "4.0",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         DataDisksGroups = new[]
 *                         {
 *                             new AzureNative.HDInsight.Inputs.DataDisksGroupsArgs
 *                             {
 *                                 DisksPerNode = 8,
 *                             },
 *                         },
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D4_v2",
 *                         },
 *                         Name = "kafkamanagementnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "kafkauser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                 },
 *             },
 *             KafkaRestProperties = new AzureNative.HDInsight.Inputs.KafkaRestPropertiesArgs
 *             {
 *                 ClientGroupInfo = new AzureNative.HDInsight.Inputs.ClientGroupInfoArgs
 *                 {
 *                     GroupId = "00000000-0000-0000-0000-111111111111",
 *                     GroupName = "Kafka security group name",
 *                 },
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Standard",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * ComponentVersion: pulumi.StringMap{
 * "Kafka": pulumi.String("2.1"),
 * },
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("kafka"),
 * },
 * ClusterVersion: pulumi.String("4.0"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Large"),
 * },
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * interface{}{
 * DataDisksGroups: hdinsight.DataDisksGroupsArray{
 * &hdinsight.DataDisksGroupsArgs{
 * DisksPerNode: pulumi.Int(8),
 * },
 * },
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Large"),
 * },
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Small"),
 * },
 * Name: pulumi.String("zookeepernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D4_v2"),
 * },
 * Name: pulumi.String("kafkamanagementnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("kafkauser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * },
 * },
 * KafkaRestProperties: interface{}{
 * ClientGroupInfo: &hdinsight.ClientGroupInfoArgs{
 * GroupId: pulumi.String("00000000-0000-0000-0000-111111111111"),
 * GroupName: pulumi.String("Kafka security group name"),
 * },
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("containername"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storagekey"),
 * Name: pulumi.String("mystorage.blob.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Standard"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("componentVersion", Map.of("Kafka", "2.1")),
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "kafka")
 *                     )),
 *                     Map.entry("clusterVersion", "4.0"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Large")),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("dataDisksGroups", Map.of("disksPerNode", 8)),
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Large")),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Small")),
 *                             Map.entry("name", "zookeepernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D4_v2")),
 *                             Map.entry("name", "kafkamanagementnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "kafkauser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ))),
 *                     Map.entry("kafkaRestProperties", Map.of("clientGroupInfo", Map.ofEntries(
 *                         Map.entry("groupId", "00000000-0000-0000-0000-111111111111"),
 *                         Map.entry("groupName", "Kafka security group name")
 *                     ))),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "containername"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storagekey"),
 *                         Map.entry("name", "mystorage.blob.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Standard")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .build());
 *         }
 * }
 * ```
 * ### Create Secure Hadoop cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.5",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         ScriptActions = new[] {},
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         ScriptActions = new[] {},
 *                         TargetInstanceCount = 4,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         ScriptActions = new[] {},
 *                         TargetInstanceCount = 3,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                 },
 *             },
 *             OsType = "Linux",
 *             SecurityProfile = new AzureNative.HDInsight.Inputs.SecurityProfileArgs
 *             {
 *                 ClusterUsersGroupDNs = new[]
 *                 {
 *                     "hdiusers",
 *                 },
 *                 DirectoryType = "ActiveDirectory",
 *                 Domain = "DomainName",
 *                 DomainUserPassword = "**********",
 *                 DomainUsername = "DomainUsername",
 *                 LdapsUrls = new[]
 *                 {
 *                     "ldaps://10.10.0.4:636",
 *                 },
 *                 OrganizationalUnitDN = "OU=Hadoop,DC=hdinsight,DC=test",
 *             },
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storage account key",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Premium",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("Hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.5"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D3_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * Password: pulumi.String("**********"),
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * ScriptActions: hdinsight.ScriptActionArray{
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * Id: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * },
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D3_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * Password: pulumi.String("**********"),
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * ScriptActions: hdinsight.ScriptActionArray{
 * },
 * TargetInstanceCount: pulumi.Int(4),
 * VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * Id: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * },
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Small"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("zookeepernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * Password: pulumi.String("**********"),
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * ScriptActions: hdinsight.ScriptActionArray{
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * Id: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * },
 * },
 * },
 * },
 * OsType: pulumi.String("Linux"),
 * SecurityProfile: &hdinsight.SecurityProfileArgs{
 * ClusterUsersGroupDNs: pulumi.StringArray{
 * pulumi.String("hdiusers"),
 * },
 * DirectoryType: pulumi.String("ActiveDirectory"),
 * Domain: pulumi.String("DomainName"),
 * DomainUserPassword: pulumi.String("**********"),
 * DomainUsername: pulumi.String("DomainUsername"),
 * LdapsUrls: pulumi.StringArray{
 * pulumi.String("ldaps://10.10.0.4:636"),
 * },
 * OrganizationalUnitDN: pulumi.String("OU=Hadoop,DC=hdinsight,DC=test"),
 * },
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("containername"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storage account key"),
 * Name: pulumi.String("mystorage.blob.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Premium"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "Hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.5"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D3_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("scriptActions", ),
 *                             Map.entry("targetInstanceCount", 2),
 *                             Map.entry("virtualNetworkProfile", Map.ofEntries(
 *                                 Map.entry("id", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 *                                 Map.entry("subnet", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D3_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("scriptActions", ),
 *                             Map.entry("targetInstanceCount", 4),
 *                             Map.entry("virtualNetworkProfile", Map.ofEntries(
 *                                 Map.entry("id", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 *                                 Map.entry("subnet", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Small")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "zookeepernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("scriptActions", ),
 *                             Map.entry("targetInstanceCount", 3),
 *                             Map.entry("virtualNetworkProfile", Map.ofEntries(
 *                                 Map.entry("id", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 *                                 Map.entry("subnet", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                             ))
 *                         ))),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("securityProfile", Map.ofEntries(
 *                         Map.entry("clusterUsersGroupDNs", "hdiusers"),
 *                         Map.entry("directoryType", "ActiveDirectory"),
 *                         Map.entry("domain", "DomainName"),
 *                         Map.entry("domainUserPassword", "**********"),
 *                         Map.entry("domainUsername", "DomainUsername"),
 *                         Map.entry("ldapsUrls", "ldaps://10.10.0.4:636"),
 *                         Map.entry("organizationalUnitDN", "OU=Hadoop,DC=hdinsight,DC=test")
 *                     )),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "containername"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storage account key"),
 *                         Map.entry("name", "mystorage.blob.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Premium")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .tags(Map.of("key1", "val1"))
 *                 .build());
 *         }
 * }
 * ```
 * ### Create Spark on Linux Cluster with SSH password
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 ComponentVersion =
 *                 {
 *                     { "Spark", "2.0" },
 *                 },
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "Spark",
 *             },
 *             ClusterVersion = "3.5",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D12_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D4_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 4,
 *                     },
 *                 },
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storageapikey*",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Standard",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * ComponentVersion: pulumi.StringMap{
 * "Spark": pulumi.String("2.0"),
 * },
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("Spark"),
 * },
 * ClusterVersion: pulumi.String("3.5"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D12_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D4_V2"),
 * },
 * MinInstanceCount: pulumi.Int(1),
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(4),
 * },
 * },
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("containername"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storageapikey*"),
 * Name: pulumi.String("mystorage.blob.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Standard"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("componentVersion", Map.of("Spark", "2.0")),
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "Spark")
 *                     )),
 *                     Map.entry("clusterVersion", "3.5"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D12_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D4_V2")),
 *                             Map.entry("minInstanceCount", 1),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 4)
 *                         ))),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "containername"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storageapikey*"),
 *                         Map.entry("name", "mystorage.blob.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Standard")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .tags(Map.of("key1", "val1"))
 *                 .build());
 *         }
 * }
 * ```
 * ### Create cluster with TLS 1.2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             MinSupportedTlsVersion = "1.2",
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "default8525",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Standard",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("Hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.6"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Large"),
 * },
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Large"),
 * },
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Small"),
 * },
 * Name: pulumi.String("zookeepernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * },
 * },
 * MinSupportedTlsVersion: pulumi.String("1.2"),
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("default8525"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storagekey"),
 * Name: pulumi.String("mystorage.blob.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Standard"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "Hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.6"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Large")),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Large")),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Small")),
 *                             Map.entry("name", "zookeepernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ))),
 *                     Map.entry("minSupportedTlsVersion", "1.2"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "default8525"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storagekey"),
 *                         Map.entry("name", "mystorage.blob.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Standard")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .build());
 *         }
 * }
 * ```
 * ### Create cluster with availability zones
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "ambari-conf",
 *                     {
 *                         { "database-name", "{ambari database name}" },
 *                         { "database-server", "{sql server name}.database.windows.net" },
 *                         { "database-user-name", "**********" },
 *                         { "database-user-password", "**********" },
 *                     } },
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                     { "hive-env",
 *                     {
 *                         { "hive_database", "Existing MSSQL Server database with SQL authentication" },
 *                         { "hive_database_name", "{hive metastore name}" },
 *                         { "hive_database_type", "mssql" },
 *                         { "hive_existing_mssql_server_database", "{hive metastore name}" },
 *                         { "hive_existing_mssql_server_host", "{sql server name}.database.windows.net" },
 *                         { "hive_hostname", "{sql server name}.database.windows.net" },
 *                     } },
 *                     { "hive-site",
 *                     {
 *                         { "javax.jdo.option.ConnectionDriverName", "com.microsoft.sqlserver.jdbc.SQLServerDriver" },
 *                         { "javax.jdo.option.ConnectionPassword", "**********!" },
 *                         { "javax.jdo.option.ConnectionURL", "jdbc:sqlserver://{sql server name}.database.windows.net;database={hive metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0" },
 *                         { "javax.jdo.option.ConnectionUserName", "**********" },
 *                     } },
 *                     { "oozie-env",
 *                     {
 *                         { "oozie_database", "Existing MSSQL Server database with SQL authentication" },
 *                         { "oozie_database_name", "{oozie metastore name}" },
 *                         { "oozie_database_type", "mssql" },
 *                         { "oozie_existing_mssql_server_database", "{oozie metastore name}" },
 *                         { "oozie_existing_mssql_server_host", "{sql server name}.database.windows.net" },
 *                         { "oozie_hostname", "{sql server name}.database.windows.net" },
 *                     } },
 *                     { "oozie-site",
 *                     {
 *                         { "oozie.db.schema.name", "oozie" },
 *                         { "oozie.service.JPAService.jdbc.driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver" },
 *                         { "oozie.service.JPAService.jdbc.password", "**********" },
 *                         { "oozie.service.JPAService.jdbc.url", "jdbc:sqlserver://{sql server name}.database.windows.net;database={oozie metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0" },
 *                         { "oozie.service.JPAService.jdbc.username", "**********" },
 *                     } },
 *                 },
 *                 Kind = "hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                 },
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storage account key",
 *                         Name = "mystorage",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * AmbariConf: map[string]interface{}{
 * "database-name": "{ambari database name}",
 * "database-server": "{sql server name}.database.windows.net",
 * "database-user-name": "**********",
 * "database-user-password": "**********",
 * },
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * HiveEnv: map[string]interface{}{
 * "hive_database": "Existing MSSQL Server database with SQL authentication",
 * "hive_database_name": "{hive metastore name}",
 * "hive_database_type": "mssql",
 * "hive_existing_mssql_server_database": "{hive metastore name}",
 * "hive_existing_mssql_server_host": "{sql server name}.database.windows.net",
 * "hive_hostname": "{sql server name}.database.windows.net",
 * },
 * HiveSite: map[string]interface{}{
 * "javax.jdo.option.ConnectionDriverName": "com.microsoft.sqlserver.jdbc.SQLServerDriver",
 * "javax.jdo.option.ConnectionPassword": "**********!",
 * "javax.jdo.option.ConnectionURL": "jdbc:sqlserver://{sql server name}.database.windows.net;database={hive metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0",
 * "javax.jdo.option.ConnectionUserName": "**********",
 * },
 * OozieEnv: map[string]interface{}{
 * "oozie_database": "Existing MSSQL Server database with SQL authentication",
 * "oozie_database_name": "{oozie metastore name}",
 * "oozie_database_type": "mssql",
 * "oozie_existing_mssql_server_database": "{oozie metastore name}",
 * "oozie_existing_mssql_server_host": "{sql server name}.database.windows.net",
 * "oozie_hostname": "{sql server name}.database.windows.net",
 * },
 * OozieSite: map[string]interface{}{
 * "oozie.db.schema.name": "oozie",
 * "oozie.service.JPAService.jdbc.driver": "com.microsoft.sqlserver.jdbc.SQLServerDriver",
 * "oozie.service.JPAService.jdbc.password": "**********",
 * "oozie.service.JPAService.jdbc.url": "jdbc:sqlserver://{sql server name}.database.windows.net;database={oozie metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0",
 * "oozie.service.JPAService.jdbc.username": "**********",
 * },
 * },
 * Kind: pulumi.String("hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.6"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("standard_d3"),
 * },
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * Password: pulumi.String("**********"),
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * Id: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * },
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("standard_d3"),
 * },
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * Password: pulumi.String("**********"),
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * Id: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * },
 * },
 * },
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("containername"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storage account key"),
 * Name: pulumi.String("mystorage"),
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Zones: pulumi.StringArray{
 * pulumi.String("1"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.ofEntries(
 *                         Map.entry("ambari-conf", ClusterCreatePropertiesArgs.builder()
 *                             .database_name("{ambari database name}")
 *                             .database_server("{sql server name}.database.windows.net")
 *                             .database_user_name("**********")
 *                             .database_user_password("**********")
 *                             .build()),
 *                         Map.entry("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression)),
 *                             Map.entry("hive-env", ClusterCreatePropertiesArgs.builder()
 *                                 .hive_database("Existing MSSQL Server database with SQL authentication")
 *                                 .hive_database_name("{hive metastore name}")
 *                                 .hive_database_type("mssql")
 *                                 .hive_existing_mssql_server_database("{hive metastore name}")
 *                                 .hive_existing_mssql_server_host("{sql server name}.database.windows.net")
 *                                 .hive_hostname("{sql server name}.database.windows.net")
 *                                 .build()),
 *                             Map.entry("hive-site", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression)),
 *                                 Map.entry("oozie-env", ClusterCreatePropertiesArgs.builder()
 *                                     .oozie_database("Existing MSSQL Server database with SQL authentication")
 *                                     .oozie_database_name("{oozie metastore name}")
 *                                     .oozie_database_type("mssql")
 *                                     .oozie_existing_mssql_server_database("{oozie metastore name}")
 *                                     .oozie_existing_mssql_server_host("{sql server name}.database.windows.net")
 *                                     .oozie_hostname("{sql server name}.database.windows.net")
 *                                     .build()),
 *                                 Map.entry("oozie-site", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))
 *                                 )),
 *                                 Map.entry("kind", "hadoop")
 *                             )),
 *                             Map.entry("clusterVersion", "3.6"),
 *                             Map.entry("computeProfile", Map.of("roles",
 *                                 Map.ofEntries(
 *                                     Map.entry("hardwareProfile", Map.of("vmSize", "standard_d3")),
 *                                     Map.entry("name", "headnode"),
 *                                     Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                         Map.entry("password", "**********"),
 *                                         Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                         Map.entry("username", "sshuser")
 *                                     ))),
 *                                     Map.entry("targetInstanceCount", 2),
 *                                     Map.entry("virtualNetworkProfile", Map.ofEntries(
 *                                         Map.entry("id", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 *                                         Map.entry("subnet", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                                     ))
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("hardwareProfile", Map.of("vmSize", "standard_d3")),
 *                                     Map.entry("name", "workernode"),
 *                                     Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                         Map.entry("password", "**********"),
 *                                         Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                         Map.entry("username", "sshuser")
 *                                     ))),
 *                                     Map.entry("targetInstanceCount", 2),
 *                                     Map.entry("virtualNetworkProfile", Map.ofEntries(
 *                                         Map.entry("id", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 *                                         Map.entry("subnet", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                                     ))
 *                                 ))),
 *                             Map.entry("osType", "Linux"),
 *                             Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                                 Map.entry("container", "containername"),
 *                                 Map.entry("isDefault", true),
 *                                 Map.entry("key", "storage account key"),
 *                                 Map.entry("name", "mystorage")
 *                             )))
 *                         ))
 *                         .resourceGroupName("rg1")
 *                         .zones("1")
 *                         .build());
 *                 }
 * }
 * ```
 * ### Create cluster with compute isolation properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeIsolationProperties = new AzureNative.HDInsight.Inputs.ComputeIsolationPropertiesArgs
 *             {
 *                 EnableComputeIsolation = true,
 *             },
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                 },
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storage account key",
 *                         Name = "mystorage",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.6"),
 * ComputeIsolationProperties: &hdinsight.ComputeIsolationPropertiesArgs{
 * EnableComputeIsolation: pulumi.Bool(true),
 * },
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("standard_d3"),
 * },
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * Password: pulumi.String("**********"),
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("standard_d3"),
 * },
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * Password: pulumi.String("**********"),
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * },
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("containername"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storage account key"),
 * Name: pulumi.String("mystorage"),
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.6"),
 *                     Map.entry("computeIsolationProperties", Map.of("enableComputeIsolation", true)),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "standard_d3")),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "standard_d3")),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ))),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "containername"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storage account key"),
 *                         Map.entry("name", "mystorage")
 *                     )))
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .build());
 *         }
 * }
 * ```
 * ### Create cluster with encryption at host
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_DS14_v2",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_DS14_v2",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_DS14_v2",
 *                         },
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             DiskEncryptionProperties = new AzureNative.HDInsight.Inputs.DiskEncryptionPropertiesArgs
 *             {
 *                 EncryptionAtHost = true,
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "default8525",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Standard",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("Hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.6"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_DS14_v2"),
 * },
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_DS14_v2"),
 * },
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_DS14_v2"),
 * },
 * Name: pulumi.String("zookeepernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * },
 * },
 * DiskEncryptionProperties: &hdinsight.DiskEncryptionPropertiesArgs{
 * EncryptionAtHost: pulumi.Bool(true),
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("default8525"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storagekey"),
 * Name: pulumi.String("mystorage.blob.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Standard"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "Hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.6"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_DS14_v2")),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_DS14_v2")),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Standard_DS14_v2")),
 *                             Map.entry("name", "zookeepernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ))),
 *                     Map.entry("diskEncryptionProperties", Map.of("encryptionAtHost", true)),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "default8525"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storagekey"),
 *                         Map.entry("name", "mystorage.blob.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Standard")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .build());
 *         }
 * }
 * ```
 * ### Create cluster with encryption in transit
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             EncryptionInTransitProperties = new AzureNative.HDInsight.Inputs.EncryptionInTransitPropertiesArgs
 *             {
 *                 IsEncryptionInTransitEnabled = true,
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "default8525",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = "Standard",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("Hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.6"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Large"),
 * },
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Large"),
 * },
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Small"),
 * },
 * Name: pulumi.String("zookeepernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * Password: pulumi.String("**********"),
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(3),
 * },
 * },
 * },
 * EncryptionInTransitProperties: &hdinsight.EncryptionInTransitPropertiesArgs{
 * IsEncryptionInTransitEnabled: pulumi.Bool(true),
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("default8525"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storagekey"),
 * Name: pulumi.String("mystorage.blob.core.windows.net"),
 * },
 * },
 * },
 * Tier: pulumi.String("Standard"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "Hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.6"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Large")),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Large")),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "Small")),
 *                             Map.entry("name", "zookeepernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 3)
 *                         ))),
 *                     Map.entry("encryptionInTransitProperties", Map.of("isEncryptionInTransitEnabled", true)),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "default8525"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storagekey"),
 *                         Map.entry("name", "mystorage.blob.core.windows.net")
 *                     ))),
 *                     Map.entry("tier", "Standard")
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .build());
 *         }
 * }
 * ```
 * ### Create cluster with network properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations =
 *                 {
 *                     { "gateway",
 *                     {
 *                         { "restAuthCredential.isEnabled", true },
 *                         { "restAuthCredential.password", "**********" },
 *                         { "restAuthCredential.username", "admin" },
 *                     } },
 *                 },
 *                 Kind = "hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                 },
 *             },
 *             NetworkProperties = new AzureNative.HDInsight.Inputs.NetworkPropertiesArgs
 *             {
 *                 PrivateLink = "Enabled",
 *                 ResourceProviderConnection = "Outbound",
 *             },
 *             OsType = "Linux",
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storage account key",
 *                         Name = "mystorage",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ClusterGetPropertiesResponse{
 * ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * Configurations: pulumi.Any{
 * Gateway: map[string]interface{}{
 * "restAuthCredential.isEnabled": true,
 * "restAuthCredential.password": "**********",
 * "restAuthCredential.username": "admin",
 * },
 * },
 * Kind: pulumi.String("hadoop"),
 * },
 * ClusterVersion: pulumi.String("3.6"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("standard_d3"),
 * },
 * Name: pulumi.String("headnode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * Password: pulumi.String("**********"),
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * Id: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * },
 * },
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("standard_d3"),
 * },
 * Name: pulumi.String("workernode"),
 * OsProfile: interface{}{
 * LinuxOperatingSystemProfile: interface{}{
 * Password: pulumi.String("**********"),
 * SshProfile: interface{}{
 * PublicKeys: hdinsight.SshPublicKeyArray{
 * &hdinsight.SshPublicKeyArgs{
 * CertificateData: pulumi.String("**********"),
 * },
 * },
 * },
 * Username: pulumi.String("sshuser"),
 * },
 * },
 * TargetInstanceCount: pulumi.Int(2),
 * VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * Id: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * },
 * },
 * },
 * },
 * NetworkProperties: &hdinsight.NetworkPropertiesArgs{
 * PrivateLink: pulumi.String("Enabled"),
 * ResourceProviderConnection: pulumi.String("Outbound"),
 * },
 * OsType: pulumi.String("Linux"),
 * StorageProfile: interface{}{
 * Storageaccounts: hdinsight.StorageAccountArray{
 * &hdinsight.StorageAccountArgs{
 * Container: pulumi.String("containername"),
 * IsDefault: pulumi.Bool(true),
 * Key: pulumi.String("storage account key"),
 * Name: pulumi.String("mystorage"),
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clusterDefinition", Map.ofEntries(
 *                     Map.entry("configurations", Map.of("gateway", ClusterCreatePropertiesArgs.builder()
 * %!v(PANIC=Format method: interface conversion: model.Expression is *model.TemplateExpression, not *model.LiteralValueExpression))),
 *                         Map.entry("kind", "hadoop")
 *                     )),
 *                     Map.entry("clusterVersion", "3.6"),
 *                     Map.entry("computeProfile", Map.of("roles",
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "standard_d3")),
 *                             Map.entry("name", "headnode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2),
 *                             Map.entry("virtualNetworkProfile", Map.ofEntries(
 *                                 Map.entry("id", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 *                                 Map.entry("subnet", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("hardwareProfile", Map.of("vmSize", "standard_d3")),
 *                             Map.entry("name", "workernode"),
 *                             Map.entry("osProfile", Map.of("linuxOperatingSystemProfile", Map.ofEntries(
 *                                 Map.entry("password", "**********"),
 *                                 Map.entry("sshProfile", Map.of("publicKeys", Map.of("certificateData", "**********"))),
 *                                 Map.entry("username", "sshuser")
 *                             ))),
 *                             Map.entry("targetInstanceCount", 2),
 *                             Map.entry("virtualNetworkProfile", Map.ofEntries(
 *                                 Map.entry("id", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 *                                 Map.entry("subnet", "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                             ))
 *                         ))),
 *                     Map.entry("networkProperties", Map.ofEntries(
 *                         Map.entry("privateLink", "Enabled"),
 *                         Map.entry("resourceProviderConnection", "Outbound")
 *                     )),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("storageProfile", Map.of("storageaccounts", Map.ofEntries(
 *                         Map.entry("container", "containername"),
 *                         Map.entry("isDefault", true),
 *                         Map.entry("key", "storage account key"),
 *                         Map.entry("name", "mystorage")
 *                     )))
 *                 ))
 *                 .resourceGroupName("rg1")
 *                 .build());
 *         }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hdinsight:Cluster cluster1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.azurenative.hdinsight.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * The ETag for the resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The identity of the cluster, if configured.
     */
    public val identity: Output<ClusterIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of the cluster.
     */
    public val properties: Output<ClusterGetPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterGetPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The availability zones.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hdinsight.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.azurenative.hdinsight.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit):
    Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
