@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.AutoscaleScheduleArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.enums.DaysOfWeek
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Parameters for a schedule-based autoscale rule, consisting of an array of days + a time and capacity
 * @property days Days of the week for a schedule-based autoscale rule
 * @property timeAndCapacity Time and capacity for a schedule-based autoscale rule
 */
public data class AutoscaleScheduleArgs(
    public val days: Output<List<Either<String, DaysOfWeek>>>? = null,
    public val timeAndCapacity: Output<AutoscaleTimeAndCapacityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.AutoscaleScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.AutoscaleScheduleArgs =
        com.pulumi.azurenative.hdinsight.inputs.AutoscaleScheduleArgs.builder()
            .days(
                days?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .timeAndCapacity(
                timeAndCapacity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AutoscaleScheduleArgs].
 */
@PulumiTagMarker
public class AutoscaleScheduleArgsBuilder internal constructor() {
    private var days: Output<List<Either<String, DaysOfWeek>>>? = null

    private var timeAndCapacity: Output<AutoscaleTimeAndCapacityArgs>? = null

    /**
     * @param value Days of the week for a schedule-based autoscale rule
     */
    @JvmName("rnbcwovjohxsdgmn")
    public suspend fun days(`value`: Output<List<Either<String, DaysOfWeek>>>) {
        this.days = value
    }

    @JvmName("kkrkjwgwucdygpco")
    public suspend fun days(vararg values: Output<Either<String, DaysOfWeek>>) {
        this.days = Output.all(values.asList())
    }

    /**
     * @param values Days of the week for a schedule-based autoscale rule
     */
    @JvmName("dnhxgkhpbvxsdpsj")
    public suspend fun days(values: List<Output<Either<String, DaysOfWeek>>>) {
        this.days = Output.all(values)
    }

    /**
     * @param value Time and capacity for a schedule-based autoscale rule
     */
    @JvmName("obmogehmolaycwpk")
    public suspend fun timeAndCapacity(`value`: Output<AutoscaleTimeAndCapacityArgs>) {
        this.timeAndCapacity = value
    }

    /**
     * @param value Days of the week for a schedule-based autoscale rule
     */
    @JvmName("hmajhwbjoaxbvdsx")
    public suspend fun days(`value`: List<Either<String, DaysOfWeek>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param values Days of the week for a schedule-based autoscale rule
     */
    @JvmName("mmekdbvrrrovjoru")
    public suspend fun days(vararg values: Either<String, DaysOfWeek>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Time and capacity for a schedule-based autoscale rule
     */
    @JvmName("bfichvrfrkkcvbjf")
    public suspend fun timeAndCapacity(`value`: AutoscaleTimeAndCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeAndCapacity = mapped
    }

    /**
     * @param argument Time and capacity for a schedule-based autoscale rule
     */
    @JvmName("mftiqssplgytblkx")
    public suspend
    fun timeAndCapacity(argument: suspend AutoscaleTimeAndCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = AutoscaleTimeAndCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeAndCapacity = mapped
    }

    internal fun build(): AutoscaleScheduleArgs = AutoscaleScheduleArgs(
        days = days,
        timeAndCapacity = timeAndCapacity,
    )
}
