@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ClientGroupInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The information of AAD security group.
 * @property groupId The AAD security group id.
 * @property groupName The AAD security group name.
 */
public data class ClientGroupInfoArgs(
    public val groupId: Output<String>? = null,
    public val groupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ClientGroupInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ClientGroupInfoArgs =
        com.pulumi.azurenative.hdinsight.inputs.ClientGroupInfoArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientGroupInfoArgs].
 */
@PulumiTagMarker
public class ClientGroupInfoArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var groupName: Output<String>? = null

    /**
     * @param value The AAD security group id.
     */
    @JvmName("xgnxljlgxywytevg")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The AAD security group name.
     */
    @JvmName("osyysfmcbihudwxr")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The AAD security group id.
     */
    @JvmName("ehqhubehjmwffflq")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The AAD security group name.
     */
    @JvmName("dvteqblmnvmulkgv")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    internal fun build(): ClientGroupInfoArgs = ClientGroupInfoArgs(
        groupId = groupId,
        groupName = groupName,
    )
}
