@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.enums.OSType
import com.pulumi.azurenative.hdinsight.kotlin.enums.Tier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The cluster create parameters.
 * @property clusterDefinition The cluster definition.
 * @property clusterVersion The version of the cluster.
 * @property computeIsolationProperties The compute isolation properties.
 * @property computeProfile The compute profile.
 * @property diskEncryptionProperties The disk encryption properties.
 * @property encryptionInTransitProperties The encryption-in-transit properties.
 * @property kafkaRestProperties The cluster kafka rest proxy configuration.
 * @property minSupportedTlsVersion The minimal supported tls version.
 * @property networkProperties The network properties.
 * @property osType The type of operating system.
 * @property privateLinkConfigurations The private link configurations.
 * @property securityProfile The security profile.
 * @property storageProfile The storage profile.
 * @property tier The cluster tier.
 */
public data class ClusterCreatePropertiesArgs(
    public val clusterDefinition: Output<ClusterDefinitionArgs>? = null,
    public val clusterVersion: Output<String>? = null,
    public val computeIsolationProperties: Output<ComputeIsolationPropertiesArgs>? = null,
    public val computeProfile: Output<ComputeProfileArgs>? = null,
    public val diskEncryptionProperties: Output<DiskEncryptionPropertiesArgs>? = null,
    public val encryptionInTransitProperties: Output<EncryptionInTransitPropertiesArgs>? = null,
    public val kafkaRestProperties: Output<KafkaRestPropertiesArgs>? = null,
    public val minSupportedTlsVersion: Output<String>? = null,
    public val networkProperties: Output<NetworkPropertiesArgs>? = null,
    public val osType: Output<Either<String, OSType>>? = null,
    public val privateLinkConfigurations: Output<List<PrivateLinkConfigurationArgs>>? = null,
    public val securityProfile: Output<SecurityProfileArgs>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
    public val tier: Output<Either<String, Tier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs =
        com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs.builder()
            .clusterDefinition(clusterDefinition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clusterVersion(clusterVersion?.applyValue({ args0 -> args0 }))
            .computeIsolationProperties(
                computeIsolationProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .computeProfile(computeProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diskEncryptionProperties(
                diskEncryptionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .encryptionInTransitProperties(
                encryptionInTransitProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .kafkaRestProperties(
                kafkaRestProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .minSupportedTlsVersion(minSupportedTlsVersion?.applyValue({ args0 -> args0 }))
            .networkProperties(networkProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .privateLinkConfigurations(
                privateLinkConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterCreatePropertiesArgs].
 */
@PulumiTagMarker
public class ClusterCreatePropertiesArgsBuilder internal constructor() {
    private var clusterDefinition: Output<ClusterDefinitionArgs>? = null

    private var clusterVersion: Output<String>? = null

    private var computeIsolationProperties: Output<ComputeIsolationPropertiesArgs>? = null

    private var computeProfile: Output<ComputeProfileArgs>? = null

    private var diskEncryptionProperties: Output<DiskEncryptionPropertiesArgs>? = null

    private var encryptionInTransitProperties: Output<EncryptionInTransitPropertiesArgs>? = null

    private var kafkaRestProperties: Output<KafkaRestPropertiesArgs>? = null

    private var minSupportedTlsVersion: Output<String>? = null

    private var networkProperties: Output<NetworkPropertiesArgs>? = null

    private var osType: Output<Either<String, OSType>>? = null

    private var privateLinkConfigurations: Output<List<PrivateLinkConfigurationArgs>>? = null

    private var securityProfile: Output<SecurityProfileArgs>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var tier: Output<Either<String, Tier>>? = null

    /**
     * @param value The cluster definition.
     */
    @JvmName("cddlbytbiupsoamk")
    public suspend fun clusterDefinition(`value`: Output<ClusterDefinitionArgs>) {
        this.clusterDefinition = value
    }

    /**
     * @param value The version of the cluster.
     */
    @JvmName("wuoheneljscmpdsr")
    public suspend fun clusterVersion(`value`: Output<String>) {
        this.clusterVersion = value
    }

    /**
     * @param value The compute isolation properties.
     */
    @JvmName("vrligtotopuuwpcl")
    public suspend fun computeIsolationProperties(`value`: Output<ComputeIsolationPropertiesArgs>) {
        this.computeIsolationProperties = value
    }

    /**
     * @param value The compute profile.
     */
    @JvmName("jmhijlqbjmoldipu")
    public suspend fun computeProfile(`value`: Output<ComputeProfileArgs>) {
        this.computeProfile = value
    }

    /**
     * @param value The disk encryption properties.
     */
    @JvmName("tcdbtpstfouvoakl")
    public suspend fun diskEncryptionProperties(`value`: Output<DiskEncryptionPropertiesArgs>) {
        this.diskEncryptionProperties = value
    }

    /**
     * @param value The encryption-in-transit properties.
     */
    @JvmName("aojcsjaqdkfaidlk")
    public suspend
    fun encryptionInTransitProperties(`value`: Output<EncryptionInTransitPropertiesArgs>) {
        this.encryptionInTransitProperties = value
    }

    /**
     * @param value The cluster kafka rest proxy configuration.
     */
    @JvmName("ofvrhpfqrmdjogcm")
    public suspend fun kafkaRestProperties(`value`: Output<KafkaRestPropertiesArgs>) {
        this.kafkaRestProperties = value
    }

    /**
     * @param value The minimal supported tls version.
     */
    @JvmName("gvolxsnchmmxemel")
    public suspend fun minSupportedTlsVersion(`value`: Output<String>) {
        this.minSupportedTlsVersion = value
    }

    /**
     * @param value The network properties.
     */
    @JvmName("fcpjeijohxsoqmsu")
    public suspend fun networkProperties(`value`: Output<NetworkPropertiesArgs>) {
        this.networkProperties = value
    }

    /**
     * @param value The type of operating system.
     */
    @JvmName("kruwarrpxbkxvyla")
    public suspend fun osType(`value`: Output<Either<String, OSType>>) {
        this.osType = value
    }

    /**
     * @param value The private link configurations.
     */
    @JvmName("ucsiseuclnqjlgbt")
    public suspend
    fun privateLinkConfigurations(`value`: Output<List<PrivateLinkConfigurationArgs>>) {
        this.privateLinkConfigurations = value
    }

    @JvmName("cpmqrtkpjsjnaepf")
    public suspend fun privateLinkConfigurations(
        vararg
        values: Output<PrivateLinkConfigurationArgs>,
    ) {
        this.privateLinkConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The private link configurations.
     */
    @JvmName("lyjcafljmlwvsxlu")
    public suspend fun privateLinkConfigurations(values: List<Output<PrivateLinkConfigurationArgs>>) {
        this.privateLinkConfigurations = Output.all(values)
    }

    /**
     * @param value The security profile.
     */
    @JvmName("bjfcwaroabmlltav")
    public suspend fun securityProfile(`value`: Output<SecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value The storage profile.
     */
    @JvmName("pedmvwmegjjapppy")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value The cluster tier.
     */
    @JvmName("ofyympunuwouensf")
    public suspend fun tier(`value`: Output<Either<String, Tier>>) {
        this.tier = value
    }

    /**
     * @param value The cluster definition.
     */
    @JvmName("kyydeadrlptnndgg")
    public suspend fun clusterDefinition(`value`: ClusterDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterDefinition = mapped
    }

    /**
     * @param argument The cluster definition.
     */
    @JvmName("ydbsabwrgbqyamwb")
    public suspend fun clusterDefinition(argument: suspend ClusterDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clusterDefinition = mapped
    }

    /**
     * @param value The version of the cluster.
     */
    @JvmName("jfskeufpeepwaywa")
    public suspend fun clusterVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterVersion = mapped
    }

    /**
     * @param value The compute isolation properties.
     */
    @JvmName("wbnbkwwvpwcckvle")
    public suspend fun computeIsolationProperties(`value`: ComputeIsolationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeIsolationProperties = mapped
    }

    /**
     * @param argument The compute isolation properties.
     */
    @JvmName("tgeowqrgeogpywpj")
    public suspend
    fun computeIsolationProperties(argument: suspend ComputeIsolationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeIsolationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.computeIsolationProperties = mapped
    }

    /**
     * @param value The compute profile.
     */
    @JvmName("gnltcbmywoyaxvgw")
    public suspend fun computeProfile(`value`: ComputeProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeProfile = mapped
    }

    /**
     * @param argument The compute profile.
     */
    @JvmName("jefntgqidhhywnjn")
    public suspend fun computeProfile(argument: suspend ComputeProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.computeProfile = mapped
    }

    /**
     * @param value The disk encryption properties.
     */
    @JvmName("whuyvuulahreqnrn")
    public suspend fun diskEncryptionProperties(`value`: DiskEncryptionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionProperties = mapped
    }

    /**
     * @param argument The disk encryption properties.
     */
    @JvmName("tyttqeokwfqxmmrl")
    public suspend
    fun diskEncryptionProperties(argument: suspend DiskEncryptionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionProperties = mapped
    }

    /**
     * @param value The encryption-in-transit properties.
     */
    @JvmName("brhgxufelribmqgc")
    public suspend fun encryptionInTransitProperties(`value`: EncryptionInTransitPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionInTransitProperties = mapped
    }

    /**
     * @param argument The encryption-in-transit properties.
     */
    @JvmName("mcwwcdfwcivbmgdv")
    public suspend
    fun encryptionInTransitProperties(argument: suspend EncryptionInTransitPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionInTransitPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionInTransitProperties = mapped
    }

    /**
     * @param value The cluster kafka rest proxy configuration.
     */
    @JvmName("knagebwxjkrlypde")
    public suspend fun kafkaRestProperties(`value`: KafkaRestPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaRestProperties = mapped
    }

    /**
     * @param argument The cluster kafka rest proxy configuration.
     */
    @JvmName("eibvrnwbckocksan")
    public suspend
    fun kafkaRestProperties(argument: suspend KafkaRestPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaRestPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kafkaRestProperties = mapped
    }

    /**
     * @param value The minimal supported tls version.
     */
    @JvmName("wqkmbbingjeojaqw")
    public suspend fun minSupportedTlsVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSupportedTlsVersion = mapped
    }

    /**
     * @param value The network properties.
     */
    @JvmName("rgcndulaqyeyeuhg")
    public suspend fun networkProperties(`value`: NetworkPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProperties = mapped
    }

    /**
     * @param argument The network properties.
     */
    @JvmName("atbchosxkfprrbop")
    public suspend fun networkProperties(argument: suspend NetworkPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProperties = mapped
    }

    /**
     * @param value The type of operating system.
     */
    @JvmName("uevjooevuatptuol")
    public suspend fun osType(`value`: Either<String, OSType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The type of operating system.
     */
    @JvmName("wfahlxwnprvqmtat")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OSType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The type of operating system.
     */
    @JvmName("hlufaeaoidimqmyp")
    public fun osType(`value`: OSType) {
        val toBeMapped = Either.ofRight<String, OSType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The private link configurations.
     */
    @JvmName("knmymmmydoomkouk")
    public suspend fun privateLinkConfigurations(`value`: List<PrivateLinkConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument The private link configurations.
     */
    @JvmName("knrcthhvwybrrppy")
    public suspend
    fun privateLinkConfigurations(argument: List<suspend PrivateLinkConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument The private link configurations.
     */
    @JvmName("uxdmphkpliaprysk")
    public suspend fun privateLinkConfigurations(
        vararg
        argument: suspend PrivateLinkConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument The private link configurations.
     */
    @JvmName("jlxbbdatigrblgrr")
    public suspend
    fun privateLinkConfigurations(argument: suspend PrivateLinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param values The private link configurations.
     */
    @JvmName("yulukwxemaxuheqn")
    public suspend fun privateLinkConfigurations(vararg values: PrivateLinkConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param value The security profile.
     */
    @JvmName("jeactkokiuhuuduo")
    public suspend fun securityProfile(`value`: SecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument The security profile.
     */
    @JvmName("eyuvrxagooetsxhf")
    public suspend fun securityProfile(argument: suspend SecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value The storage profile.
     */
    @JvmName("cxryuomvdammpmii")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument The storage profile.
     */
    @JvmName("givejdyqvqlmbsjy")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value The cluster tier.
     */
    @JvmName("glbnsyxibqfduyaf")
    public suspend fun tier(`value`: Either<String, Tier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The cluster tier.
     */
    @JvmName("vwahgwnbvodvlguq")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Tier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The cluster tier.
     */
    @JvmName("hsmgrsurokovahol")
    public fun tier(`value`: Tier) {
        val toBeMapped = Either.ofRight<String, Tier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ClusterCreatePropertiesArgs = ClusterCreatePropertiesArgs(
        clusterDefinition = clusterDefinition,
        clusterVersion = clusterVersion,
        computeIsolationProperties = computeIsolationProperties,
        computeProfile = computeProfile,
        diskEncryptionProperties = diskEncryptionProperties,
        encryptionInTransitProperties = encryptionInTransitProperties,
        kafkaRestProperties = kafkaRestProperties,
        minSupportedTlsVersion = minSupportedTlsVersion,
        networkProperties = networkProperties,
        osType = osType,
        privateLinkConfigurations = privateLinkConfigurations,
        securityProfile = securityProfile,
        storageProfile = storageProfile,
        tier = tier,
    )
}
