@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.NetworkPropertiesArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.enums.PrivateLink
import com.pulumi.azurenative.hdinsight.kotlin.enums.ResourceProviderConnection
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The network properties.
 * @property privateLink Indicates whether or not private link is enabled.
 * @property resourceProviderConnection The direction for the resource provider connection.
 */
public data class NetworkPropertiesArgs(
    public val privateLink: Output<Either<String, PrivateLink>>? = null,
    public val resourceProviderConnection: Output<Either<String, ResourceProviderConnection>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.NetworkPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.NetworkPropertiesArgs =
        com.pulumi.azurenative.hdinsight.inputs.NetworkPropertiesArgs.builder()
            .privateLink(
                privateLink?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceProviderConnection(
                resourceProviderConnection?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [NetworkPropertiesArgs].
 */
@PulumiTagMarker
public class NetworkPropertiesArgsBuilder internal constructor() {
    private var privateLink: Output<Either<String, PrivateLink>>? = null

    private var resourceProviderConnection: Output<Either<String, ResourceProviderConnection>>? = null

    /**
     * @param value Indicates whether or not private link is enabled.
     */
    @JvmName("dyqdkdwrfsmbsump")
    public suspend fun privateLink(`value`: Output<Either<String, PrivateLink>>) {
        this.privateLink = value
    }

    /**
     * @param value The direction for the resource provider connection.
     */
    @JvmName("emdexirsjwhhnhop")
    public suspend
    fun resourceProviderConnection(`value`: Output<Either<String, ResourceProviderConnection>>) {
        this.resourceProviderConnection = value
    }

    /**
     * @param value Indicates whether or not private link is enabled.
     */
    @JvmName("atytmqxmttmebpcc")
    public suspend fun privateLink(`value`: Either<String, PrivateLink>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLink = mapped
    }

    /**
     * @param value Indicates whether or not private link is enabled.
     */
    @JvmName("uhpvmiefbgjqgtnm")
    public fun privateLink(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLink>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLink = mapped
    }

    /**
     * @param value Indicates whether or not private link is enabled.
     */
    @JvmName("mlytrnbtcobrknyy")
    public fun privateLink(`value`: PrivateLink) {
        val toBeMapped = Either.ofRight<String, PrivateLink>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLink = mapped
    }

    /**
     * @param value The direction for the resource provider connection.
     */
    @JvmName("nrtvpcskiojqqoqh")
    public suspend
    fun resourceProviderConnection(`value`: Either<String, ResourceProviderConnection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceProviderConnection = mapped
    }

    /**
     * @param value The direction for the resource provider connection.
     */
    @JvmName("wrxrkvjjovexfnhj")
    public fun resourceProviderConnection(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceProviderConnection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceProviderConnection = mapped
    }

    /**
     * @param value The direction for the resource provider connection.
     */
    @JvmName("uhhemnmqarwyxxwb")
    public fun resourceProviderConnection(`value`: ResourceProviderConnection) {
        val toBeMapped = Either.ofRight<String, ResourceProviderConnection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceProviderConnection = mapped
    }

    internal fun build(): NetworkPropertiesArgs = NetworkPropertiesArgs(
        privateLink = privateLink,
        resourceProviderConnection = resourceProviderConnection,
    )
}
