@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.OsProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Linux operation systems profile.
 * @property linuxOperatingSystemProfile The Linux OS profile.
 */
public data class OsProfileArgs(
    public val linuxOperatingSystemProfile: Output<LinuxOperatingSystemProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.OsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.OsProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.OsProfileArgs.builder()
            .linuxOperatingSystemProfile(
                linuxOperatingSystemProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OsProfileArgs].
 */
@PulumiTagMarker
public class OsProfileArgsBuilder internal constructor() {
    private var linuxOperatingSystemProfile: Output<LinuxOperatingSystemProfileArgs>? = null

    /**
     * @param value The Linux OS profile.
     */
    @JvmName("lkujkaqwkcsuctqd")
    public suspend fun linuxOperatingSystemProfile(`value`: Output<LinuxOperatingSystemProfileArgs>) {
        this.linuxOperatingSystemProfile = value
    }

    /**
     * @param value The Linux OS profile.
     */
    @JvmName("btrktgermcwfclmh")
    public suspend fun linuxOperatingSystemProfile(`value`: LinuxOperatingSystemProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxOperatingSystemProfile = mapped
    }

    /**
     * @param argument The Linux OS profile.
     */
    @JvmName("jbxrxmfefwdtliep")
    public suspend
    fun linuxOperatingSystemProfile(argument: suspend LinuxOperatingSystemProfileArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxOperatingSystemProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxOperatingSystemProfile = mapped
    }

    internal fun build(): OsProfileArgs = OsProfileArgs(
        linuxOperatingSystemProfile = linuxOperatingSystemProfile,
    )
}
