@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.RoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a role on the cluster.
 * @property autoscaleConfiguration The autoscale configurations.
 * @property dataDisksGroups The data disks groups for the role.
 * @property encryptDataDisks Indicates whether encrypt the data disks.
 * @property hardwareProfile The hardware profile.
 * @property minInstanceCount The minimum instance count of the cluster.
 * @property name The name of the role.
 * @property osProfile The operating system profile.
 * @property scriptActions The list of script actions on the role.
 * @property targetInstanceCount The instance count of the cluster.
 * @property vMGroupName The name of the virtual machine group.
 * @property virtualNetworkProfile The virtual network profile.
 */
public data class RoleArgs(
    public val autoscaleConfiguration: Output<AutoscaleArgs>? = null,
    public val dataDisksGroups: Output<List<DataDisksGroupsArgs>>? = null,
    public val encryptDataDisks: Output<Boolean>? = null,
    public val hardwareProfile: Output<HardwareProfileArgs>? = null,
    public val minInstanceCount: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val osProfile: Output<OsProfileArgs>? = null,
    public val scriptActions: Output<List<ScriptActionArgs>>? = null,
    public val targetInstanceCount: Output<Int>? = null,
    public val vMGroupName: Output<String>? = null,
    public val virtualNetworkProfile: Output<VirtualNetworkProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.RoleArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.RoleArgs =
        com.pulumi.azurenative.hdinsight.inputs.RoleArgs.builder()
            .autoscaleConfiguration(
                autoscaleConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataDisksGroups(
                dataDisksGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .encryptDataDisks(encryptDataDisks?.applyValue({ args0 -> args0 }))
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .minInstanceCount(minInstanceCount?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scriptActions(
                scriptActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetInstanceCount(targetInstanceCount?.applyValue({ args0 -> args0 }))
            .vMGroupName(vMGroupName?.applyValue({ args0 -> args0 }))
            .virtualNetworkProfile(
                virtualNetworkProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RoleArgs].
 */
@PulumiTagMarker
public class RoleArgsBuilder internal constructor() {
    private var autoscaleConfiguration: Output<AutoscaleArgs>? = null

    private var dataDisksGroups: Output<List<DataDisksGroupsArgs>>? = null

    private var encryptDataDisks: Output<Boolean>? = null

    private var hardwareProfile: Output<HardwareProfileArgs>? = null

    private var minInstanceCount: Output<Int>? = null

    private var name: Output<String>? = null

    private var osProfile: Output<OsProfileArgs>? = null

    private var scriptActions: Output<List<ScriptActionArgs>>? = null

    private var targetInstanceCount: Output<Int>? = null

    private var vMGroupName: Output<String>? = null

    private var virtualNetworkProfile: Output<VirtualNetworkProfileArgs>? = null

    /**
     * @param value The autoscale configurations.
     */
    @JvmName("cdvlxrwminqyhupu")
    public suspend fun autoscaleConfiguration(`value`: Output<AutoscaleArgs>) {
        this.autoscaleConfiguration = value
    }

    /**
     * @param value The data disks groups for the role.
     */
    @JvmName("wxfsrxsbfphciown")
    public suspend fun dataDisksGroups(`value`: Output<List<DataDisksGroupsArgs>>) {
        this.dataDisksGroups = value
    }

    @JvmName("xhqilqriqkjecdtg")
    public suspend fun dataDisksGroups(vararg values: Output<DataDisksGroupsArgs>) {
        this.dataDisksGroups = Output.all(values.asList())
    }

    /**
     * @param values The data disks groups for the role.
     */
    @JvmName("mvmfdbasntyifjwq")
    public suspend fun dataDisksGroups(values: List<Output<DataDisksGroupsArgs>>) {
        this.dataDisksGroups = Output.all(values)
    }

    /**
     * @param value Indicates whether encrypt the data disks.
     */
    @JvmName("yiaoekurmlpoyeue")
    public suspend fun encryptDataDisks(`value`: Output<Boolean>) {
        this.encryptDataDisks = value
    }

    /**
     * @param value The hardware profile.
     */
    @JvmName("cljhevpaixpmnwaa")
    public suspend fun hardwareProfile(`value`: Output<HardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value The minimum instance count of the cluster.
     */
    @JvmName("helwkiscjqywdnht")
    public suspend fun minInstanceCount(`value`: Output<Int>) {
        this.minInstanceCount = value
    }

    /**
     * @param value The name of the role.
     */
    @JvmName("ypivmeqdsflkmsup")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The operating system profile.
     */
    @JvmName("scucmjxvvdfheegg")
    public suspend fun osProfile(`value`: Output<OsProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value The list of script actions on the role.
     */
    @JvmName("ugbvyfwwmvmlarlm")
    public suspend fun scriptActions(`value`: Output<List<ScriptActionArgs>>) {
        this.scriptActions = value
    }

    @JvmName("hradifeadlgrctdf")
    public suspend fun scriptActions(vararg values: Output<ScriptActionArgs>) {
        this.scriptActions = Output.all(values.asList())
    }

    /**
     * @param values The list of script actions on the role.
     */
    @JvmName("tottxpteyqhrdddp")
    public suspend fun scriptActions(values: List<Output<ScriptActionArgs>>) {
        this.scriptActions = Output.all(values)
    }

    /**
     * @param value The instance count of the cluster.
     */
    @JvmName("vpvscyurslumjpms")
    public suspend fun targetInstanceCount(`value`: Output<Int>) {
        this.targetInstanceCount = value
    }

    /**
     * @param value The name of the virtual machine group.
     */
    @JvmName("ohxfyryvrfymodyq")
    public suspend fun vMGroupName(`value`: Output<String>) {
        this.vMGroupName = value
    }

    /**
     * @param value The virtual network profile.
     */
    @JvmName("kvlkjctnjigpwuao")
    public suspend fun virtualNetworkProfile(`value`: Output<VirtualNetworkProfileArgs>) {
        this.virtualNetworkProfile = value
    }

    /**
     * @param value The autoscale configurations.
     */
    @JvmName("gewvdjkydnoawcgj")
    public suspend fun autoscaleConfiguration(`value`: AutoscaleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscaleConfiguration = mapped
    }

    /**
     * @param argument The autoscale configurations.
     */
    @JvmName("ndbhuqcfxdxncwew")
    public suspend fun autoscaleConfiguration(argument: suspend AutoscaleArgsBuilder.() -> Unit) {
        val toBeMapped = AutoscaleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoscaleConfiguration = mapped
    }

    /**
     * @param value The data disks groups for the role.
     */
    @JvmName("qwdrealvnnuebhxh")
    public suspend fun dataDisksGroups(`value`: List<DataDisksGroupsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisksGroups = mapped
    }

    /**
     * @param argument The data disks groups for the role.
     */
    @JvmName("frmmvvbygvxoojur")
    public suspend
    fun dataDisksGroups(argument: List<suspend DataDisksGroupsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataDisksGroupsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisksGroups = mapped
    }

    /**
     * @param argument The data disks groups for the role.
     */
    @JvmName("kwhgjlfvfccvnpir")
    public suspend fun dataDisksGroups(
        vararg
        argument: suspend DataDisksGroupsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataDisksGroupsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisksGroups = mapped
    }

    /**
     * @param argument The data disks groups for the role.
     */
    @JvmName("uvrabheiijjxsipr")
    public suspend fun dataDisksGroups(argument: suspend DataDisksGroupsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataDisksGroupsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisksGroups = mapped
    }

    /**
     * @param values The data disks groups for the role.
     */
    @JvmName("qvvpjnxbtlohbahu")
    public suspend fun dataDisksGroups(vararg values: DataDisksGroupsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisksGroups = mapped
    }

    /**
     * @param value Indicates whether encrypt the data disks.
     */
    @JvmName("sxvghjbokuckjtbj")
    public suspend fun encryptDataDisks(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptDataDisks = mapped
    }

    /**
     * @param value The hardware profile.
     */
    @JvmName("fipmonughmdgscdr")
    public suspend fun hardwareProfile(`value`: HardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument The hardware profile.
     */
    @JvmName("owyqyewnrddrnfvp")
    public suspend fun hardwareProfile(argument: suspend HardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HardwareProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value The minimum instance count of the cluster.
     */
    @JvmName("fpogoatwcsmtwhrb")
    public suspend fun minInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minInstanceCount = mapped
    }

    /**
     * @param value The name of the role.
     */
    @JvmName("lkxfmnomqudhhsys")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The operating system profile.
     */
    @JvmName("jkesvkdcdpkdbjeu")
    public suspend fun osProfile(`value`: OsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument The operating system profile.
     */
    @JvmName("jalagbmvqomuqkie")
    public suspend fun osProfile(argument: suspend OsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value The list of script actions on the role.
     */
    @JvmName("lhfoikvcachdswuh")
    public suspend fun scriptActions(`value`: List<ScriptActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptActions = mapped
    }

    /**
     * @param argument The list of script actions on the role.
     */
    @JvmName("bbyrglyoeugoedjo")
    public suspend fun scriptActions(argument: List<suspend ScriptActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScriptActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scriptActions = mapped
    }

    /**
     * @param argument The list of script actions on the role.
     */
    @JvmName("dnkqinwhibgqetmh")
    public suspend fun scriptActions(vararg argument: suspend ScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScriptActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scriptActions = mapped
    }

    /**
     * @param argument The list of script actions on the role.
     */
    @JvmName("snkrktuflgrthltp")
    public suspend fun scriptActions(argument: suspend ScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScriptActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scriptActions = mapped
    }

    /**
     * @param values The list of script actions on the role.
     */
    @JvmName("erqrvjgsxtimirbm")
    public suspend fun scriptActions(vararg values: ScriptActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scriptActions = mapped
    }

    /**
     * @param value The instance count of the cluster.
     */
    @JvmName("oeaegndpujafreqg")
    public suspend fun targetInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetInstanceCount = mapped
    }

    /**
     * @param value The name of the virtual machine group.
     */
    @JvmName("tvslqmjnkvdgarlr")
    public suspend fun vMGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vMGroupName = mapped
    }

    /**
     * @param value The virtual network profile.
     */
    @JvmName("rrevaqwnuxyouqfg")
    public suspend fun virtualNetworkProfile(`value`: VirtualNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkProfile = mapped
    }

    /**
     * @param argument The virtual network profile.
     */
    @JvmName("ihrgwypfxnmtsddl")
    public suspend
    fun virtualNetworkProfile(argument: suspend VirtualNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkProfile = mapped
    }

    internal fun build(): RoleArgs = RoleArgs(
        autoscaleConfiguration = autoscaleConfiguration,
        dataDisksGroups = dataDisksGroups,
        encryptDataDisks = encryptDataDisks,
        hardwareProfile = hardwareProfile,
        minInstanceCount = minInstanceCount,
        name = name,
        osProfile = osProfile,
        scriptActions = scriptActions,
        targetInstanceCount = targetInstanceCount,
        vMGroupName = vMGroupName,
        virtualNetworkProfile = virtualNetworkProfile,
    )
}
