@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.RuntimeScriptActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a script action on a running cluster.
 * @property name The name of the script action.
 * @property parameters The parameters for the script
 * @property roles The list of roles where script will be executed.
 * @property uri The URI to the script.
 */
public data class RuntimeScriptActionArgs(
    public val name: Output<String>,
    public val parameters: Output<String>? = null,
    public val roles: Output<List<String>>,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.RuntimeScriptActionArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.RuntimeScriptActionArgs =
        com.pulumi.azurenative.hdinsight.inputs.RuntimeScriptActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .roles(roles.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuntimeScriptActionArgs].
 */
@PulumiTagMarker
public class RuntimeScriptActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<String>? = null

    private var roles: Output<List<String>>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The name of the script action.
     */
    @JvmName("vcghrlfnmttmshiw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters for the script
     */
    @JvmName("plsokdgogmkhwfmk")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value The list of roles where script will be executed.
     */
    @JvmName("gosgraxgycodsvjt")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("shndrxqmhwggmchu")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values The list of roles where script will be executed.
     */
    @JvmName("uyrrnobwuwhkntua")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value The URI to the script.
     */
    @JvmName("tprtsslexsffarej")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The name of the script action.
     */
    @JvmName("xqffflgpojjrxvgl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters for the script
     */
    @JvmName("pbfdsmnxdjhbqsww")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The list of roles where script will be executed.
     */
    @JvmName("rasiusekxgveiahx")
    public suspend fun roles(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values The list of roles where script will be executed.
     */
    @JvmName("bwahsrfetmeipiio")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value The URI to the script.
     */
    @JvmName("vasyeufulisflktc")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): RuntimeScriptActionArgs = RuntimeScriptActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters,
        roles = roles ?: throw PulumiNullFieldException("roles"),
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
