@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.SshProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The list of SSH public keys.
 * @property publicKeys The list of SSH public keys.
 */
public data class SshProfileArgs(
    public val publicKeys: Output<List<SshPublicKeyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.SshProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.SshProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.SshProfileArgs.builder()
            .publicKeys(
                publicKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SshProfileArgs].
 */
@PulumiTagMarker
public class SshProfileArgsBuilder internal constructor() {
    private var publicKeys: Output<List<SshPublicKeyArgs>>? = null

    /**
     * @param value The list of SSH public keys.
     */
    @JvmName("wrfmcronbahljodw")
    public suspend fun publicKeys(`value`: Output<List<SshPublicKeyArgs>>) {
        this.publicKeys = value
    }

    @JvmName("crkbjdbasrjotkmg")
    public suspend fun publicKeys(vararg values: Output<SshPublicKeyArgs>) {
        this.publicKeys = Output.all(values.asList())
    }

    /**
     * @param values The list of SSH public keys.
     */
    @JvmName("dbvsqirrhypdmsao")
    public suspend fun publicKeys(values: List<Output<SshPublicKeyArgs>>) {
        this.publicKeys = Output.all(values)
    }

    /**
     * @param value The list of SSH public keys.
     */
    @JvmName("stjijgullrlbcevm")
    public suspend fun publicKeys(`value`: List<SshPublicKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param argument The list of SSH public keys.
     */
    @JvmName("labhnbnmvudkvlee")
    public suspend fun publicKeys(argument: List<suspend SshPublicKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument The list of SSH public keys.
     */
    @JvmName("fbxlvwplsecwbyqg")
    public suspend fun publicKeys(vararg argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument The list of SSH public keys.
     */
    @JvmName("lfudngpkenbtjnog")
    public suspend fun publicKeys(argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SshPublicKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param values The list of SSH public keys.
     */
    @JvmName("wmbdhnlfyfvgjkcd")
    public suspend fun publicKeys(vararg values: SshPublicKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    internal fun build(): SshProfileArgs = SshProfileArgs(
        publicKeys = publicKeys,
    )
}
