@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The storage profile.
 * @property storageaccounts The list of storage accounts in the cluster.
 */
public data class StorageProfileArgs(
    public val storageaccounts: Output<List<StorageAccountArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs.builder()
            .storageaccounts(
                storageaccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageProfileArgs].
 */
@PulumiTagMarker
public class StorageProfileArgsBuilder internal constructor() {
    private var storageaccounts: Output<List<StorageAccountArgs>>? = null

    /**
     * @param value The list of storage accounts in the cluster.
     */
    @JvmName("suijlvwtlxvfjcet")
    public suspend fun storageaccounts(`value`: Output<List<StorageAccountArgs>>) {
        this.storageaccounts = value
    }

    @JvmName("emddhvilehyuvsjk")
    public suspend fun storageaccounts(vararg values: Output<StorageAccountArgs>) {
        this.storageaccounts = Output.all(values.asList())
    }

    /**
     * @param values The list of storage accounts in the cluster.
     */
    @JvmName("cmvtoyyhugxlnefn")
    public suspend fun storageaccounts(values: List<Output<StorageAccountArgs>>) {
        this.storageaccounts = Output.all(values)
    }

    /**
     * @param value The list of storage accounts in the cluster.
     */
    @JvmName("ljbyyfgcksmmlqfk")
    public suspend fun storageaccounts(`value`: List<StorageAccountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageaccounts = mapped
    }

    /**
     * @param argument The list of storage accounts in the cluster.
     */
    @JvmName("variykbxnnvcjijn")
    public suspend fun storageaccounts(argument: List<suspend StorageAccountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageaccounts = mapped
    }

    /**
     * @param argument The list of storage accounts in the cluster.
     */
    @JvmName("turotqsloulhlsku")
    public suspend fun storageaccounts(
        vararg
        argument: suspend StorageAccountArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageaccounts = mapped
    }

    /**
     * @param argument The list of storage accounts in the cluster.
     */
    @JvmName("ccuxaowwljtaobvf")
    public suspend fun storageaccounts(argument: suspend StorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageAccountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageaccounts = mapped
    }

    /**
     * @param values The list of storage accounts in the cluster.
     */
    @JvmName("uragkdcuapabtbck")
    public suspend fun storageaccounts(vararg values: StorageAccountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageaccounts = mapped
    }

    internal fun build(): StorageProfileArgs = StorageProfileArgs(
        storageaccounts = storageaccounts,
    )
}
