@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Gets the application HTTP endpoints.
 * @property accessModes The list of access modes for the application.
 * @property destinationPort The destination port to connect to.
 * @property disableGatewayAuth The value indicates whether to disable GatewayAuth.
 * @property location The location of the endpoint.
 * @property privateIPAddress The private ip address of the endpoint.
 * @property publicPort The public port to connect to.
 */
public data class ApplicationGetHttpsEndpointResponse(
    public val accessModes: List<String>? = null,
    public val destinationPort: Int? = null,
    public val disableGatewayAuth: Boolean? = null,
    public val location: String,
    public val privateIPAddress: String? = null,
    public val publicPort: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ApplicationGetHttpsEndpointResponse):
            ApplicationGetHttpsEndpointResponse = ApplicationGetHttpsEndpointResponse(
            accessModes = javaType.accessModes().map({ args0 -> args0 }),
            destinationPort = javaType.destinationPort().map({ args0 -> args0 }).orElse(null),
            disableGatewayAuth = javaType.disableGatewayAuth().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            publicPort = javaType.publicPort(),
        )
    }
}
