@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Schedule-based autoscale request parameters
 * @property schedule Array of schedule-based autoscale rules
 * @property timeZone The time zone for the autoscale schedule times
 */
public data class AutoscaleRecurrenceResponse(
    public val schedule: List<AutoscaleScheduleResponse>? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.AutoscaleRecurrenceResponse):
            AutoscaleRecurrenceResponse = AutoscaleRecurrenceResponse(
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.AutoscaleScheduleResponse.Companion.toKotlin(args0)
                })
            }),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
