@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The security profile which contains Ssh public key for the HDInsight cluster.
 * @property aaddsResourceId The resource ID of the user's Azure Active Directory Domain Service.
 * @property clusterUsersGroupDNs Optional. The Distinguished Names for cluster user groups
 * @property directoryType The directory type.
 * @property domain The organization's active directory domain.
 * @property domainUserPassword The domain admin password.
 * @property domainUsername The domain user account that will have admin privileges on the cluster.
 * @property ldapsUrls The LDAPS protocol URLs to communicate with the Active Directory.
 * @property msiResourceId User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
 * @property organizationalUnitDN The organizational unit within the Active Directory to place the cluster and service accounts.
 */
public data class SecurityProfileResponse(
    public val aaddsResourceId: String? = null,
    public val clusterUsersGroupDNs: List<String>? = null,
    public val directoryType: String? = null,
    public val domain: String? = null,
    public val domainUserPassword: String? = null,
    public val domainUsername: String? = null,
    public val ldapsUrls: List<String>? = null,
    public val msiResourceId: String? = null,
    public val organizationalUnitDN: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.SecurityProfileResponse):
            SecurityProfileResponse = SecurityProfileResponse(
            aaddsResourceId = javaType.aaddsResourceId().map({ args0 -> args0 }).orElse(null),
            clusterUsersGroupDNs = javaType.clusterUsersGroupDNs().map({ args0 -> args0 }),
            directoryType = javaType.directoryType().map({ args0 -> args0 }).orElse(null),
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            domainUserPassword = javaType.domainUserPassword().map({ args0 -> args0 }).orElse(null),
            domainUsername = javaType.domainUsername().map({ args0 -> args0 }).orElse(null),
            ldapsUrls = javaType.ldapsUrls().map({ args0 -> args0 }),
            msiResourceId = javaType.msiResourceId().map({ args0 -> args0 }).orElse(null),
            organizationalUnitDN = javaType.organizationalUnitDN().map({ args0 -> args0 }).orElse(null),
        )
    }
}
