@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin.inputs

import com.pulumi.azurenative.healthbot.inputs.GetBotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property botName The name of the Bot resource.
 * @property resourceGroupName The name of the Bot resource group in the user subscription.
 */
public data class GetBotPlainArgs(
    public val botName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.healthbot.inputs.GetBotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.healthbot.inputs.GetBotPlainArgs =
        com.pulumi.azurenative.healthbot.inputs.GetBotPlainArgs.builder()
            .botName(botName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBotPlainArgs].
 */
@PulumiTagMarker
public class GetBotPlainArgsBuilder internal constructor() {
    private var botName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("cpgxeawcrfsjewwa")
    public suspend fun botName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.botName = mapped
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("jwcureeaxsqbktan")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBotPlainArgs = GetBotPlainArgs(
        botName = botName ?: throw PulumiNullFieldException("botName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
