@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin.inputs

import com.pulumi.azurenative.healthbot.inputs.HealthBotPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of a Azure Health Bot. The Health Bot Service is a cloud platform that empowers developers in Healthcare organizations to build and deploy their compliant, AI-powered virtual health assistants and health bots, that help them improve processes and reduce costs.
 * @property keyVaultProperties KeyVault properties for the resource encryption.
 */
public data class HealthBotPropertiesArgs(
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthbot.inputs.HealthBotPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.healthbot.inputs.HealthBotPropertiesArgs =
        com.pulumi.azurenative.healthbot.inputs.HealthBotPropertiesArgs.builder()
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [HealthBotPropertiesArgs].
 */
@PulumiTagMarker
public class HealthBotPropertiesArgsBuilder internal constructor() {
    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    /**
     * @param value KeyVault properties for the resource encryption.
     */
    @JvmName("rsfchinskgqeanov")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value KeyVault properties for the resource encryption.
     */
    @JvmName("oofnnbambyhdkiie")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument KeyVault properties for the resource encryption.
     */
    @JvmName("taanueieqegokyxg")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    internal fun build(): HealthBotPropertiesArgs = HealthBotPropertiesArgs(
        keyVaultProperties = keyVaultProperties,
    )
}
