@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.kotlin.outputs.CorsConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.DicomServiceAuthenticationConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.CorsConfigurationResponse.Companion.toKotlin as corsConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.DicomServiceAuthenticationConfigurationResponse.Companion.toKotlin as dicomServiceAuthenticationConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity.Companion.toKotlin as serviceManagedIdentityResponseIdentityToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DicomService].
 */
@PulumiTagMarker
public class DicomServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DicomServiceArgs = DicomServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DicomServiceArgsBuilder.() -> Unit) {
        val builder = DicomServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DicomService {
        val builtJavaResource =
            com.pulumi.azurenative.healthcareapis.DicomService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DicomService(builtJavaResource)
    }
}

/**
 * The description of Dicom Service
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01.
 * ## Example Usage
 * ### Create or update a Dicom Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dicomService = new AzureNative.HealthcareApis.DicomService("dicomService", new()
 *     {
 *         DicomServiceName = "blue",
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewDicomService(ctx, "dicomService", &healthcareapis.DicomServiceArgs{
 * 			DicomServiceName:  pulumi.String("blue"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			WorkspaceName:     pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.DicomService;
 * import com.pulumi.azurenative.healthcareapis.DicomServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dicomService = new DicomService("dicomService", DicomServiceArgs.builder()
 *             .dicomServiceName("blue")
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:DicomService blue /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/dicomservices/{dicomServiceName}
 * ```
 */
public class DicomService internal constructor(
    override val javaResource: com.pulumi.azurenative.healthcareapis.DicomService,
) : KotlinCustomResource(javaResource, DicomServiceMapper) {
    /**
     * Dicom Service authentication configuration.
     */
    public val authenticationConfiguration: Output<DicomServiceAuthenticationConfigurationResponse>?
        get() = javaResource.authenticationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dicomServiceAuthenticationConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Dicom Service Cors configuration.
     */
    public val corsConfiguration: Output<CorsConfigurationResponse>?
        get() = javaResource.corsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> corsConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An etag associated with the resource, used for optimistic concurrency when editing it.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * DICOM Service event support status.
     */
    public val eventState: Output<String>
        get() = javaResource.eventState().applyValue({ args0 -> args0 })

    /**
     * Setting indicating whether the service has a managed identity associated with it.
     */
    public val identity: Output<ServiceManagedIdentityResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceManagedIdentityResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of private endpoint connections that are set up for this resource.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    public val publicNetworkAccess: Output<String>
        get() = javaResource.publicNetworkAccess().applyValue({ args0 -> args0 })

    /**
     * The url of the Dicom Services.
     */
    public val serviceUrl: Output<String>
        get() = javaResource.serviceUrl().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DicomServiceMapper : ResourceMapper<DicomService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.healthcareapis.DicomService::class == javaResource::class

    override fun map(javaResource: Resource): DicomService = DicomService(
        javaResource as
            com.pulumi.azurenative.healthcareapis.DicomService,
    )
}

/**
 * @see [DicomService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DicomService].
 */
public suspend fun dicomService(
    name: String,
    block: suspend DicomServiceResourceBuilder.() -> Unit,
): DicomService {
    val builder = DicomServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DicomService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dicomService(name: String): DicomService {
    val builder = DicomServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
