@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceAccessPolicyEntryResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceAcrConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceAuthenticationConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceCorsConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceExportConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceImportConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ImplementationGuidesConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ResourceVersionPolicyConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceAccessPolicyEntryResponse.Companion.toKotlin as fhirServiceAccessPolicyEntryResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceAcrConfigurationResponse.Companion.toKotlin as fhirServiceAcrConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceAuthenticationConfigurationResponse.Companion.toKotlin as fhirServiceAuthenticationConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceCorsConfigurationResponse.Companion.toKotlin as fhirServiceCorsConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceExportConfigurationResponse.Companion.toKotlin as fhirServiceExportConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceImportConfigurationResponse.Companion.toKotlin as fhirServiceImportConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ImplementationGuidesConfigurationResponse.Companion.toKotlin as implementationGuidesConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ResourceVersionPolicyConfigurationResponse.Companion.toKotlin as resourceVersionPolicyConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity.Companion.toKotlin as serviceManagedIdentityResponseIdentityToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [FhirService].
 */
@PulumiTagMarker
public class FhirServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FhirServiceArgs = FhirServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FhirServiceArgsBuilder.() -> Unit) {
        val builder = FhirServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FhirService {
        val builtJavaResource =
            com.pulumi.azurenative.healthcareapis.FhirService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FhirService(builtJavaResource)
    }
}

/**
 * The description of Fhir Service
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01.
 * ## Example Usage
 * ### Create or update a Fhir Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fhirService = new AzureNative.HealthcareApis.FhirService("fhirService", new()
 *     {
 *         AccessPolicies = new[]
 *         {
 *             new AzureNative.HealthcareApis.Inputs.FhirServiceAccessPolicyEntryArgs
 *             {
 *                 ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *             },
 *             new AzureNative.HealthcareApis.Inputs.FhirServiceAccessPolicyEntryArgs
 *             {
 *                 ObjectId = "5b307da8-43d4-492b-8b66-b0294ade872f",
 *             },
 *         },
 *         AcrConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceAcrConfigurationArgs
 *         {
 *             LoginServers = new[]
 *             {
 *                 "test1.azurecr.io",
 *             },
 *         },
 *         AuthenticationConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceAuthenticationConfigurationArgs
 *         {
 *             Audience = "https://azurehealthcareapis.com",
 *             Authority = "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc",
 *             SmartProxyEnabled = true,
 *         },
 *         CorsConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceCorsConfigurationArgs
 *         {
 *             AllowCredentials = false,
 *             Headers = new[]
 *             {
 *                 "*",
 *             },
 *             MaxAge = 1440,
 *             Methods = new[]
 *             {
 *                 "DELETE",
 *                 "GET",
 *                 "OPTIONS",
 *                 "PATCH",
 *                 "POST",
 *                 "PUT",
 *             },
 *             Origins = new[]
 *             {
 *                 "*",
 *             },
 *         },
 *         ExportConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceExportConfigurationArgs
 *         {
 *             StorageAccountName = "existingStorageAccount",
 *         },
 *         FhirServiceName = "fhirservice1",
 *         Identity = new AzureNative.HealthcareApis.Inputs.ServiceManagedIdentityIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         ImplementationGuidesConfiguration = new AzureNative.HealthcareApis.Inputs.ImplementationGuidesConfigurationArgs
 *         {
 *             UsCoreMissingData = false,
 *         },
 *         ImportConfiguration = new AzureNative.HealthcareApis.Inputs.FhirServiceImportConfigurationArgs
 *         {
 *             Enabled = false,
 *             InitialImportMode = false,
 *             IntegrationDataStore = "existingStorageAccount",
 *         },
 *         Kind = "fhir-R4",
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         Tags =
 *         {
 *             { "additionalProp1", "string" },
 *             { "additionalProp2", "string" },
 *             { "additionalProp3", "string" },
 *         },
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewFhirService(ctx, "fhirService", &healthcareapis.FhirServiceArgs{
 * 			AccessPolicies: []healthcareapis.FhirServiceAccessPolicyEntryArgs{
 * 				{
 * 					ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 				},
 * 				{
 * 					ObjectId: pulumi.String("5b307da8-43d4-492b-8b66-b0294ade872f"),
 * 				},
 * 			},
 * 			AcrConfiguration: &healthcareapis.FhirServiceAcrConfigurationArgs{
 * 				LoginServers: pulumi.StringArray{
 * 					pulumi.String("test1.azurecr.io"),
 * 				},
 * 			},
 * 			AuthenticationConfiguration: &healthcareapis.FhirServiceAuthenticationConfigurationArgs{
 * 				Audience:          pulumi.String("https://azurehealthcareapis.com"),
 * 				Authority:         pulumi.String("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 * 				SmartProxyEnabled: pulumi.Bool(true),
 * 			},
 * 			CorsConfiguration: &healthcareapis.FhirServiceCorsConfigurationArgs{
 * 				AllowCredentials: pulumi.Bool(false),
 * 				Headers: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 				MaxAge: pulumi.Int(1440),
 * 				Methods: pulumi.StringArray{
 * 					pulumi.String("DELETE"),
 * 					pulumi.String("GET"),
 * 					pulumi.String("OPTIONS"),
 * 					pulumi.String("PATCH"),
 * 					pulumi.String("POST"),
 * 					pulumi.String("PUT"),
 * 				},
 * 				Origins: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 			},
 * 			ExportConfiguration: &healthcareapis.FhirServiceExportConfigurationArgs{
 * 				StorageAccountName: pulumi.String("existingStorageAccount"),
 * 			},
 * 			FhirServiceName: pulumi.String("fhirservice1"),
 * 			Identity: &healthcareapis.ServiceManagedIdentityIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			ImplementationGuidesConfiguration: &healthcareapis.ImplementationGuidesConfigurationArgs{
 * 				UsCoreMissingData: pulumi.Bool(false),
 * 			},
 * 			ImportConfiguration: &healthcareapis.FhirServiceImportConfigurationArgs{
 * 				Enabled:              pulumi.Bool(false),
 * 				InitialImportMode:    pulumi.Bool(false),
 * 				IntegrationDataStore: pulumi.String("existingStorageAccount"),
 * 			},
 * 			Kind:              pulumi.String("fhir-R4"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			Tags: pulumi.StringMap{
 * 				"additionalProp1": pulumi.String("string"),
 * 				"additionalProp2": pulumi.String("string"),
 * 				"additionalProp3": pulumi.String("string"),
 * 			},
 * 			WorkspaceName: pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.FhirService;
 * import com.pulumi.azurenative.healthcareapis.FhirServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fhirService = new FhirService("fhirService", FhirServiceArgs.builder()
 *             .accessPolicies(
 *                 Map.of("objectId", "c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 *                 Map.of("objectId", "5b307da8-43d4-492b-8b66-b0294ade872f"))
 *             .acrConfiguration(Map.of("loginServers", "test1.azurecr.io"))
 *             .authenticationConfiguration(Map.ofEntries(
 *                 Map.entry("audience", "https://azurehealthcareapis.com"),
 *                 Map.entry("authority", "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 *                 Map.entry("smartProxyEnabled", true)
 *             ))
 *             .corsConfiguration(Map.ofEntries(
 *                 Map.entry("allowCredentials", false),
 *                 Map.entry("headers", "*"),
 *                 Map.entry("maxAge", 1440),
 *                 Map.entry("methods",
 *                     "DELETE",
 *                     "GET",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT"),
 *                 Map.entry("origins", "*")
 *             ))
 *             .exportConfiguration(Map.of("storageAccountName", "existingStorageAccount"))
 *             .fhirServiceName("fhirservice1")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .implementationGuidesConfiguration(Map.of("usCoreMissingData", false))
 *             .importConfiguration(Map.ofEntries(
 *                 Map.entry("enabled", false),
 *                 Map.entry("initialImportMode", false),
 *                 Map.entry("integrationDataStore", "existingStorageAccount")
 *             ))
 *             .kind("fhir-R4")
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .tags(Map.ofEntries(
 *                 Map.entry("additionalProp1", "string"),
 *                 Map.entry("additionalProp2", "string"),
 *                 Map.entry("additionalProp3", "string")
 *             ))
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:FhirService fhirservice1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/fhirservices/{fhirServiceName}
 * ```
 */
public class FhirService internal constructor(
    override val javaResource: com.pulumi.azurenative.healthcareapis.FhirService,
) : KotlinCustomResource(javaResource, FhirServiceMapper) {
    /**
     * Fhir Service access policies.
     */
    public val accessPolicies: Output<List<FhirServiceAccessPolicyEntryResponse>>?
        get() = javaResource.accessPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        fhirServiceAccessPolicyEntryResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Fhir Service Azure container registry configuration.
     */
    public val acrConfiguration: Output<FhirServiceAcrConfigurationResponse>?
        get() = javaResource.acrConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fhirServiceAcrConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Fhir Service authentication configuration.
     */
    public val authenticationConfiguration: Output<FhirServiceAuthenticationConfigurationResponse>?
        get() = javaResource.authenticationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    fhirServiceAuthenticationConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Fhir Service Cors configuration.
     */
    public val corsConfiguration: Output<FhirServiceCorsConfigurationResponse>?
        get() = javaResource.corsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fhirServiceCorsConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An etag associated with the resource, used for optimistic concurrency when editing it.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Fhir Service event support status.
     */
    public val eventState: Output<String>
        get() = javaResource.eventState().applyValue({ args0 -> args0 })

    /**
     * Fhir Service export configuration.
     */
    public val exportConfiguration: Output<FhirServiceExportConfigurationResponse>?
        get() = javaResource.exportConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fhirServiceExportConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Setting indicating whether the service has a managed identity associated with it.
     */
    public val identity: Output<ServiceManagedIdentityResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceManagedIdentityResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Implementation Guides configuration.
     */
    public val implementationGuidesConfiguration: Output<ImplementationGuidesConfigurationResponse>?
        get() = javaResource.implementationGuidesConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    implementationGuidesConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Fhir Service import configuration.
     */
    public val importConfiguration: Output<FhirServiceImportConfigurationResponse>?
        get() = javaResource.importConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fhirServiceImportConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The kind of the service.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of private endpoint connections that are set up for this resource.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    public val publicNetworkAccess: Output<String>
        get() = javaResource.publicNetworkAccess().applyValue({ args0 -> args0 })

    /**
     * Determines tracking of history for resources.
     */
    public val resourceVersionPolicyConfiguration: Output<ResourceVersionPolicyConfigurationResponse>?
        get() = javaResource.resourceVersionPolicyConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceVersionPolicyConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FhirServiceMapper : ResourceMapper<FhirService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.healthcareapis.FhirService::class == javaResource::class

    override fun map(javaResource: Resource): FhirService = FhirService(
        javaResource as
            com.pulumi.azurenative.healthcareapis.FhirService,
    )
}

/**
 * @see [FhirService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FhirService].
 */
public suspend fun fhirService(name: String, block: suspend FhirServiceResourceBuilder.() -> Unit):
    FhirService {
    val builder = FhirServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FhirService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fhirService(name: String): FhirService {
    val builder = FhirServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
