@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.IotConnectorArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.IotEventHubIngestionEndpointConfigurationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.IotEventHubIngestionEndpointConfigurationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.IotMappingPropertiesArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.IotMappingPropertiesArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServiceManagedIdentityIdentityArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServiceManagedIdentityIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * IoT Connector definition.
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01.
 * ## Example Usage
 * ### Create an IoT Connector
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotConnector = new AzureNative.HealthcareApis.IotConnector("iotConnector", new()
 *     {
 *         DeviceMapping = new AzureNative.HealthcareApis.Inputs.IotMappingPropertiesArgs
 *         {
 *             Content =
 *             {
 *                 { "template", new[]
 *                 {
 *                     {
 *                         { "template",
 *                         {
 *                             { "deviceIdExpression", "$.deviceid" },
 *                             { "timestampExpression", "$.measurementdatetime" },
 *                             { "typeMatchExpression", "$..[?(@heartrate)]" },
 *                             { "typeName", "heartrate" },
 *                             { "values", new[]
 *                             {
 *                                 {
 *                                     { "required", "true" },
 *                                     { "valueExpression", "$.heartrate" },
 *                                     { "valueName", "hr" },
 *                                 },
 *                             } },
 *                         } },
 *                         { "templateType", "JsonPathContent" },
 *                     },
 *                 } },
 *                 { "templateType", "CollectionContent" },
 *             },
 *         },
 *         Identity = new AzureNative.HealthcareApis.Inputs.ServiceManagedIdentityIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         IngestionEndpointConfiguration = new AzureNative.HealthcareApis.Inputs.IotEventHubIngestionEndpointConfigurationArgs
 *         {
 *             ConsumerGroup = "ConsumerGroupA",
 *             EventHubName = "MyEventHubName",
 *             FullyQualifiedEventHubNamespace = "myeventhub.servicesbus.windows.net",
 *         },
 *         IotConnectorName = "blue",
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         Tags =
 *         {
 *             { "additionalProp1", "string" },
 *             { "additionalProp2", "string" },
 *             { "additionalProp3", "string" },
 *         },
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewIotConnector(ctx, "iotConnector", &healthcareapis.IotConnectorArgs{
 * 			DeviceMapping: &healthcareapis.IotMappingPropertiesArgs{
 * 				Content: pulumi.Any{
 * 					Template: []map[string]interface{}{
 * 						map[string]interface{}{
 * 							"template": map[string]interface{}{
 * 								"deviceIdExpression":  "$.deviceid",
 * 								"timestampExpression": "$.measurementdatetime",
 * 								"typeMatchExpression": "$..[?(@heartrate)]",
 * 								"typeName":            "heartrate",
 * 								"values": []map[string]interface{}{
 * 									map[string]interface{}{
 * 										"required":        "true",
 * 										"valueExpression": "$.heartrate",
 * 										"valueName":       "hr",
 * 									},
 * 								},
 * 							},
 * 							"templateType": "JsonPathContent",
 * 						},
 * 					},
 * 					TemplateType: "CollectionContent",
 * 				},
 * 			},
 * 			Identity: &healthcareapis.ServiceManagedIdentityIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			IngestionEndpointConfiguration: &healthcareapis.IotEventHubIngestionEndpointConfigurationArgs{
 * 				ConsumerGroup:                   pulumi.String("ConsumerGroupA"),
 * 				EventHubName:                    pulumi.String("MyEventHubName"),
 * 				FullyQualifiedEventHubNamespace: pulumi.String("myeventhub.servicesbus.windows.net"),
 * 			},
 * 			IotConnectorName:  pulumi.String("blue"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			Tags: pulumi.StringMap{
 * 				"additionalProp1": pulumi.String("string"),
 * 				"additionalProp2": pulumi.String("string"),
 * 				"additionalProp3": pulumi.String("string"),
 * 			},
 * 			WorkspaceName: pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.IotConnector;
 * import com.pulumi.azurenative.healthcareapis.IotConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotConnector = new IotConnector("iotConnector", IotConnectorArgs.builder()
 *             .deviceMapping(Map.of("content", Map.ofEntries(
 *                 Map.entry("template", IotMappingPropertiesArgs.builder()
 *                     .template(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .templateType("JsonPathContent")
 *                     .build()),
 *                 Map.entry("templateType", "CollectionContent")
 *             )))
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .ingestionEndpointConfiguration(Map.ofEntries(
 *                 Map.entry("consumerGroup", "ConsumerGroupA"),
 *                 Map.entry("eventHubName", "MyEventHubName"),
 *                 Map.entry("fullyQualifiedEventHubNamespace", "myeventhub.servicesbus.windows.net")
 *             ))
 *             .iotConnectorName("blue")
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .tags(Map.ofEntries(
 *                 Map.entry("additionalProp1", "string"),
 *                 Map.entry("additionalProp2", "string"),
 *                 Map.entry("additionalProp3", "string")
 *             ))
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:IotConnector blue /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/iotconnectors/{iotConnectorName}
 * ```
 * @property deviceMapping Device Mappings.
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property ingestionEndpointConfiguration Source configuration.
 * @property iotConnectorName The name of IoT Connector resource.
 * @property location The resource location.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property tags Resource tags.
 * @property workspaceName The name of workspace resource.
 */
public data class IotConnectorArgs(
    public val deviceMapping: Output<IotMappingPropertiesArgs>? = null,
    public val identity: Output<ServiceManagedIdentityIdentityArgs>? = null,
    public val ingestionEndpointConfiguration: Output<IotEventHubIngestionEndpointConfigurationArgs>? =
        null,
    public val iotConnectorName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.IotConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.IotConnectorArgs =
        com.pulumi.azurenative.healthcareapis.IotConnectorArgs.builder()
            .deviceMapping(deviceMapping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ingestionEndpointConfiguration(
                ingestionEndpointConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .iotConnectorName(iotConnectorName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotConnectorArgs].
 */
@PulumiTagMarker
public class IotConnectorArgsBuilder internal constructor() {
    private var deviceMapping: Output<IotMappingPropertiesArgs>? = null

    private var identity: Output<ServiceManagedIdentityIdentityArgs>? = null

    private var ingestionEndpointConfiguration: Output<IotEventHubIngestionEndpointConfigurationArgs>? =
        null

    private var iotConnectorName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Device Mappings.
     */
    @JvmName("tmqspodawanksaky")
    public suspend fun deviceMapping(`value`: Output<IotMappingPropertiesArgs>) {
        this.deviceMapping = value
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("aokdqafhhbdarntt")
    public suspend fun identity(`value`: Output<ServiceManagedIdentityIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Source configuration.
     */
    @JvmName("ialukqcjywofhron")
    public suspend
    fun ingestionEndpointConfiguration(`value`: Output<IotEventHubIngestionEndpointConfigurationArgs>) {
        this.ingestionEndpointConfiguration = value
    }

    /**
     * @param value The name of IoT Connector resource.
     */
    @JvmName("ecfaycevrwjqpcoy")
    public suspend fun iotConnectorName(`value`: Output<String>) {
        this.iotConnectorName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("gigtieogvnfsbcph")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("fvtactnaenakvkep")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vftprfgmhhwoalvj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("ikoankefixxcqpjj")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Device Mappings.
     */
    @JvmName("hvxgacnisfjpgght")
    public suspend fun deviceMapping(`value`: IotMappingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceMapping = mapped
    }

    /**
     * @param argument Device Mappings.
     */
    @JvmName("oheaprsedjixlsoe")
    public suspend fun deviceMapping(argument: suspend IotMappingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IotMappingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deviceMapping = mapped
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("xqrfbxievrxjetpw")
    public suspend fun identity(`value`: ServiceManagedIdentityIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("cuyqdbhppnipqpgw")
    public suspend
    fun identity(argument: suspend ServiceManagedIdentityIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceManagedIdentityIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Source configuration.
     */
    @JvmName("iraqlyqdbgagwmct")
    public suspend
    fun ingestionEndpointConfiguration(`value`: IotEventHubIngestionEndpointConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionEndpointConfiguration = mapped
    }

    /**
     * @param argument Source configuration.
     */
    @JvmName("meceygjktftyunwx")
    public suspend
    fun ingestionEndpointConfiguration(argument: suspend IotEventHubIngestionEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IotEventHubIngestionEndpointConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ingestionEndpointConfiguration = mapped
    }

    /**
     * @param value The name of IoT Connector resource.
     */
    @JvmName("xsycdvempnvpnwvv")
    public suspend fun iotConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotConnectorName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("jdmqsoiiidudmfwv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("asmrlntrvcutvlxv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xoixasoeylomoyri")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jhwihqggujjjvhxb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("mmfvylerklurpdet")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): IotConnectorArgs = IotConnectorArgs(
        deviceMapping = deviceMapping,
        identity = identity,
        ingestionEndpointConfiguration = ingestionEndpointConfiguration,
        iotConnectorName = iotConnectorName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workspaceName = workspaceName,
    )
}
