@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAuthenticationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authentication configuration information
 * @property audience The audience url for the service
 * @property authority The authority url for the service
 * @property smartProxyEnabled If the SMART on FHIR proxy is enabled
 */
public data class FhirServiceAuthenticationConfigurationArgs(
    public val audience: Output<String>? = null,
    public val authority: Output<String>? = null,
    public val smartProxyEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAuthenticationConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAuthenticationConfigurationArgs =
        com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAuthenticationConfigurationArgs.builder()
            .audience(audience?.applyValue({ args0 -> args0 }))
            .authority(authority?.applyValue({ args0 -> args0 }))
            .smartProxyEnabled(smartProxyEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FhirServiceAuthenticationConfigurationArgs].
 */
@PulumiTagMarker
public class FhirServiceAuthenticationConfigurationArgsBuilder internal constructor() {
    private var audience: Output<String>? = null

    private var authority: Output<String>? = null

    private var smartProxyEnabled: Output<Boolean>? = null

    /**
     * @param value The audience url for the service
     */
    @JvmName("pbmukbvphbtagunu")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value The authority url for the service
     */
    @JvmName("nndllghedmhgnmcu")
    public suspend fun authority(`value`: Output<String>) {
        this.authority = value
    }

    /**
     * @param value If the SMART on FHIR proxy is enabled
     */
    @JvmName("icikojtcjmhlndyo")
    public suspend fun smartProxyEnabled(`value`: Output<Boolean>) {
        this.smartProxyEnabled = value
    }

    /**
     * @param value The audience url for the service
     */
    @JvmName("aksiocpcwpwkvycf")
    public suspend fun audience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value The authority url for the service
     */
    @JvmName("dclhhwflogvyacdv")
    public suspend fun authority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authority = mapped
    }

    /**
     * @param value If the SMART on FHIR proxy is enabled
     */
    @JvmName("fgojnnbrkoprogoi")
    public suspend fun smartProxyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smartProxyEnabled = mapped
    }

    internal fun build(): FhirServiceAuthenticationConfigurationArgs =
        FhirServiceAuthenticationConfigurationArgs(
            audience = audience,
            authority = authority,
            smartProxyEnabled = smartProxyEnabled,
        )
}
