@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.GetIotConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property iotConnectorName The name of IoT Connector resource.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property workspaceName The name of workspace resource.
 */
public data class GetIotConnectorPlainArgs(
    public val iotConnectorName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.GetIotConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.GetIotConnectorPlainArgs =
        com.pulumi.azurenative.healthcareapis.inputs.GetIotConnectorPlainArgs.builder()
            .iotConnectorName(iotConnectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIotConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetIotConnectorPlainArgsBuilder internal constructor() {
    private var iotConnectorName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of IoT Connector resource.
     */
    @JvmName("dnfukuhncuprwdfq")
    public suspend fun iotConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.iotConnectorName = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("lxqibceavjfargsy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("sdcxejlckwgxquiy")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetIotConnectorPlainArgs = GetIotConnectorPlainArgs(
        iotConnectorName = iotConnectorName ?: throw PulumiNullFieldException("iotConnectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
