@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.ServiceCosmosDbConfigurationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The settings for the Cosmos DB database backing the service.
 * @property crossTenantCmkApplicationId The multi-tenant application id used to enable CMK access for services in a data sovereign region.
 * @property keyVaultKeyUri The URI of the customer-managed key for the backing database.
 * @property offerThroughput The provisioned throughput for the backing database.
 */
public data class ServiceCosmosDbConfigurationInfoArgs(
    public val crossTenantCmkApplicationId: Output<String>? = null,
    public val keyVaultKeyUri: Output<String>? = null,
    public val offerThroughput: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.ServiceCosmosDbConfigurationInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.ServiceCosmosDbConfigurationInfoArgs =
        com.pulumi.azurenative.healthcareapis.inputs.ServiceCosmosDbConfigurationInfoArgs.builder()
            .crossTenantCmkApplicationId(crossTenantCmkApplicationId?.applyValue({ args0 -> args0 }))
            .keyVaultKeyUri(keyVaultKeyUri?.applyValue({ args0 -> args0 }))
            .offerThroughput(offerThroughput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceCosmosDbConfigurationInfoArgs].
 */
@PulumiTagMarker
public class ServiceCosmosDbConfigurationInfoArgsBuilder internal constructor() {
    private var crossTenantCmkApplicationId: Output<String>? = null

    private var keyVaultKeyUri: Output<String>? = null

    private var offerThroughput: Output<Int>? = null

    /**
     * @param value The multi-tenant application id used to enable CMK access for services in a data sovereign region.
     */
    @JvmName("abpnaspjlrxhbpxs")
    public suspend fun crossTenantCmkApplicationId(`value`: Output<String>) {
        this.crossTenantCmkApplicationId = value
    }

    /**
     * @param value The URI of the customer-managed key for the backing database.
     */
    @JvmName("omxhsmgswcaubybx")
    public suspend fun keyVaultKeyUri(`value`: Output<String>) {
        this.keyVaultKeyUri = value
    }

    /**
     * @param value The provisioned throughput for the backing database.
     */
    @JvmName("lrwvtyfybfeebpnr")
    public suspend fun offerThroughput(`value`: Output<Int>) {
        this.offerThroughput = value
    }

    /**
     * @param value The multi-tenant application id used to enable CMK access for services in a data sovereign region.
     */
    @JvmName("wcjavrmwgbextkef")
    public suspend fun crossTenantCmkApplicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossTenantCmkApplicationId = mapped
    }

    /**
     * @param value The URI of the customer-managed key for the backing database.
     */
    @JvmName("spymaskgcvvmxkch")
    public suspend fun keyVaultKeyUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultKeyUri = mapped
    }

    /**
     * @param value The provisioned throughput for the backing database.
     */
    @JvmName("bmaaqmluytwmqtum")
    public suspend fun offerThroughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerThroughput = mapped
    }

    internal fun build(): ServiceCosmosDbConfigurationInfoArgs = ServiceCosmosDbConfigurationInfoArgs(
        crossTenantCmkApplicationId = crossTenantCmkApplicationId,
        keyVaultKeyUri = keyVaultKeyUri,
        offerThroughput = offerThroughput,
    )
}
