@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The FHIR service data source for Analytics Connector.
 * @property kind The kind of FHIR Service.
 * @property type Type of data source.
 * Expected value is 'fhirservice'.
 * @property url The URL of FHIR service.
 */
public data class AnalyticsConnectorFhirServiceDataSourceResponse(
    public val kind: String,
    public val type: String,
    public val url: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.AnalyticsConnectorFhirServiceDataSourceResponse):
            AnalyticsConnectorFhirServiceDataSourceResponse =
            AnalyticsConnectorFhirServiceDataSourceResponse(
                kind = javaType.kind(),
                type = javaType.type(),
                url = javaType.url(),
            )
    }
}
