@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Analytics Connector definition.
 * @property dataDestinationConfiguration Data destination configuration for Analytics Connector.
 * @property dataMappingConfiguration Data mapping configuration for Analytics Connector.
 * @property dataSourceConfiguration Data source for Analytics Connector.
 * @property etag An etag associated with the resource, used for optimistic concurrency when editing it.
 * @property id The resource identifier.
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property location The resource location.
 * @property name The resource name.
 * @property provisioningState The provisioning state.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The resource type.
 */
public data class GetAnalyticsConnectorResult(
    public val dataDestinationConfiguration: AnalyticsConnectorDataLakeDataDestinationResponse,
    public val dataMappingConfiguration: AnalyticsConnectorFhirToParquetMappingResponse,
    public val dataSourceConfiguration: AnalyticsConnectorFhirServiceDataSourceResponse,
    public val etag: String? = null,
    public val id: String,
    public val identity: ServiceManagedIdentityResponseIdentity? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.GetAnalyticsConnectorResult):
            GetAnalyticsConnectorResult = GetAnalyticsConnectorResult(
            dataDestinationConfiguration = javaType.dataDestinationConfiguration().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.AnalyticsConnectorDataLakeDataDestinationResponse.Companion.toKotlin(args0)
            }),
            dataMappingConfiguration = javaType.dataMappingConfiguration().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.AnalyticsConnectorFhirToParquetMappingResponse.Companion.toKotlin(args0)
            }),
            dataSourceConfiguration = javaType.dataSourceConfiguration().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.AnalyticsConnectorFhirServiceDataSourceResponse.Companion.toKotlin(args0)
            }),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
