@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Event Hub ingestion endpoint configuration
 * @property consumerGroup Consumer group of the event hub to connected to.
 * @property eventHubName Event Hub name to connect to.
 * @property fullyQualifiedEventHubNamespace Fully qualified namespace of the Event Hub to connect to.
 */
public data class IotEventHubIngestionEndpointConfigurationResponse(
    public val consumerGroup: String? = null,
    public val eventHubName: String? = null,
    public val fullyQualifiedEventHubNamespace: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.IotEventHubIngestionEndpointConfigurationResponse):
            IotEventHubIngestionEndpointConfigurationResponse =
            IotEventHubIngestionEndpointConfigurationResponse(
                consumerGroup = javaType.consumerGroup().map({ args0 -> args0 }).orElse(null),
                eventHubName = javaType.eventHubName().map({ args0 -> args0 }).orElse(null),
                fullyQualifiedEventHubNamespace = javaType.fullyQualifiedEventHubNamespace().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
