@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The settings for the Cosmos DB database backing the service.
 * @property crossTenantCmkApplicationId The multi-tenant application id used to enable CMK access for services in a data sovereign region.
 * @property keyVaultKeyUri The URI of the customer-managed key for the backing database.
 * @property offerThroughput The provisioned throughput for the backing database.
 */
public data class ServiceCosmosDbConfigurationInfoResponse(
    public val crossTenantCmkApplicationId: String? = null,
    public val keyVaultKeyUri: String? = null,
    public val offerThroughput: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.ServiceCosmosDbConfigurationInfoResponse):
            ServiceCosmosDbConfigurationInfoResponse = ServiceCosmosDbConfigurationInfoResponse(
            crossTenantCmkApplicationId = javaType.crossTenantCmkApplicationId().map({ args0 ->
                args0
            }).orElse(null),
            keyVaultKeyUri = javaType.keyVaultKeyUri().map({ args0 -> args0 }).orElse(null),
            offerThroughput = javaType.offerThroughput().map({ args0 -> args0 }).orElse(null),
        )
    }
}
