@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcloud.kotlin.inputs

import com.pulumi.azurenative.hybridcloud.inputs.GetCloudConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudConnectorName The name of the cloud connector resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCloudConnectorPlainArgs(
    public val cloudConnectorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcloud.inputs.GetCloudConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcloud.inputs.GetCloudConnectorPlainArgs =
        com.pulumi.azurenative.hybridcloud.inputs.GetCloudConnectorPlainArgs.builder()
            .cloudConnectorName(cloudConnectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetCloudConnectorPlainArgsBuilder internal constructor() {
    private var cloudConnectorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cloud connector resource
     */
    @JvmName("hnwknhdhjcxiytam")
    public suspend fun cloudConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudConnectorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ecchuapvrixrmrbs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCloudConnectorPlainArgs = GetCloudConnectorPlainArgs(
        cloudConnectorName = cloudConnectorName ?: throw PulumiNullFieldException("cloudConnectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
