@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.HybridcomputeFunctions.getLicensePlain
import com.pulumi.azurenative.hybridcompute.HybridcomputeFunctions.getLicenseProfilePlain
import com.pulumi.azurenative.hybridcompute.HybridcomputeFunctions.getMachineExtensionPlain
import com.pulumi.azurenative.hybridcompute.HybridcomputeFunctions.getMachinePlain
import com.pulumi.azurenative.hybridcompute.HybridcomputeFunctions.getMachineRunCommandPlain
import com.pulumi.azurenative.hybridcompute.HybridcomputeFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.hybridcompute.HybridcomputeFunctions.getPrivateLinkScopePlain
import com.pulumi.azurenative.hybridcompute.HybridcomputeFunctions.getPrivateLinkScopedResourcePlain
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetLicensePlainArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetLicensePlainArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetLicenseProfilePlainArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetLicenseProfilePlainArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetMachineExtensionPlainArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetMachineExtensionPlainArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetMachinePlainArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetMachinePlainArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetMachineRunCommandPlainArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetMachineRunCommandPlainArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetPrivateLinkScopePlainArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetPrivateLinkScopePlainArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetPrivateLinkScopedResourcePlainArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.GetPrivateLinkScopedResourcePlainArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetLicenseProfileResult
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetLicenseResult
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetMachineExtensionResult
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetMachineResult
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetMachineRunCommandResult
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetPrivateLinkScopeResult
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetPrivateLinkScopedResourceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetLicenseProfileResult.Companion.toKotlin as getLicenseProfileResultToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetLicenseResult.Companion.toKotlin as getLicenseResultToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetMachineExtensionResult.Companion.toKotlin as getMachineExtensionResultToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetMachineResult.Companion.toKotlin as getMachineResultToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetMachineRunCommandResult.Companion.toKotlin as getMachineRunCommandResultToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetPrivateLinkScopeResult.Companion.toKotlin as getPrivateLinkScopeResultToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.GetPrivateLinkScopedResourceResult.Companion.toKotlin as getPrivateLinkScopedResourceResultToKotlin

public object HybridcomputeFunctions {
    /**
     * Retrieves information about the view of a license.
     * Azure REST API version: 2023-06-20-preview.
     * Other available API versions: 2023-10-03-preview.
     * @param argument null
     * @return Describes a license in a hybrid machine.
     */
    public suspend fun getLicense(argument: GetLicensePlainArgs): GetLicenseResult =
        getLicenseResultToKotlin(getLicensePlain(argument.toJava()).await())

    /**
     * @see [getLicense].
     * @param licenseName The name of the license.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Describes a license in a hybrid machine.
     */
    public suspend fun getLicense(licenseName: String, resourceGroupName: String): GetLicenseResult {
        val argument = GetLicensePlainArgs(
            licenseName = licenseName,
            resourceGroupName = resourceGroupName,
        )
        return getLicenseResultToKotlin(getLicensePlain(argument.toJava()).await())
    }

    /**
     * @see [getLicense].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcompute&#46;kotlin&#46;inputs&#46;GetLicensePlainArgs].
     * @return Describes a license in a hybrid machine.
     */
    public suspend fun getLicense(argument: suspend GetLicensePlainArgsBuilder.() -> Unit):
        GetLicenseResult {
        val builder = GetLicensePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLicenseResultToKotlin(getLicensePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about the view of a license profile.
     * Azure REST API version: 2023-06-20-preview.
     * Other available API versions: 2023-10-03-preview.
     * @param argument null
     * @return Describes a license profile in a hybrid machine.
     */
    public suspend fun getLicenseProfile(argument: GetLicenseProfilePlainArgs):
        GetLicenseProfileResult =
        getLicenseProfileResultToKotlin(getLicenseProfilePlain(argument.toJava()).await())

    /**
     * @see [getLicenseProfile].
     * @param licenseProfileName The name of the license profile.
     * @param machineName The name of the hybrid machine.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Describes a license profile in a hybrid machine.
     */
    public suspend fun getLicenseProfile(
        licenseProfileName: String,
        machineName: String,
        resourceGroupName: String,
    ): GetLicenseProfileResult {
        val argument = GetLicenseProfilePlainArgs(
            licenseProfileName = licenseProfileName,
            machineName = machineName,
            resourceGroupName = resourceGroupName,
        )
        return getLicenseProfileResultToKotlin(getLicenseProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getLicenseProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcompute&#46;kotlin&#46;inputs&#46;GetLicenseProfilePlainArgs].
     * @return Describes a license profile in a hybrid machine.
     */
    public suspend
    fun getLicenseProfile(argument: suspend GetLicenseProfilePlainArgsBuilder.() -> Unit):
        GetLicenseProfileResult {
        val builder = GetLicenseProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLicenseProfileResultToKotlin(getLicenseProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about the model view or the instance view of a hybrid machine.
     * Azure REST API version: 2022-12-27.
     * Other available API versions: 2019-03-18-preview, 2019-08-02-preview, 2020-08-02, 2020-08-15-preview, 2022-05-10-preview, 2023-06-20-preview, 2023-10-03-preview.
     * @param argument null
     * @return Describes a hybrid machine.
     */
    public suspend fun getMachine(argument: GetMachinePlainArgs): GetMachineResult =
        getMachineResultToKotlin(getMachinePlain(argument.toJava()).await())

    /**
     * @see [getMachine].
     * @param expand The expand expression to apply on the operation.
     * @param machineName The name of the hybrid machine.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Describes a hybrid machine.
     */
    public suspend fun getMachine(
        expand: String? = null,
        machineName: String,
        resourceGroupName: String,
    ): GetMachineResult {
        val argument = GetMachinePlainArgs(
            expand = expand,
            machineName = machineName,
            resourceGroupName = resourceGroupName,
        )
        return getMachineResultToKotlin(getMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcompute&#46;kotlin&#46;inputs&#46;GetMachinePlainArgs].
     * @return Describes a hybrid machine.
     */
    public suspend fun getMachine(argument: suspend GetMachinePlainArgsBuilder.() -> Unit):
        GetMachineResult {
        val builder = GetMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachineResultToKotlin(getMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the extension.
     * Azure REST API version: 2022-12-27.
     * Other available API versions: 2019-08-02-preview, 2020-08-15-preview, 2022-05-10-preview, 2023-06-20-preview, 2023-10-03-preview.
     * @param argument null
     * @return Describes a Machine Extension.
     */
    public suspend fun getMachineExtension(argument: GetMachineExtensionPlainArgs):
        GetMachineExtensionResult =
        getMachineExtensionResultToKotlin(getMachineExtensionPlain(argument.toJava()).await())

    /**
     * @see [getMachineExtension].
     * @param extensionName The name of the machine extension.
     * @param machineName The name of the machine containing the extension.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Describes a Machine Extension.
     */
    public suspend fun getMachineExtension(
        extensionName: String,
        machineName: String,
        resourceGroupName: String,
    ): GetMachineExtensionResult {
        val argument = GetMachineExtensionPlainArgs(
            extensionName = extensionName,
            machineName = machineName,
            resourceGroupName = resourceGroupName,
        )
        return getMachineExtensionResultToKotlin(getMachineExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMachineExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcompute&#46;kotlin&#46;inputs&#46;GetMachineExtensionPlainArgs].
     * @return Describes a Machine Extension.
     */
    public suspend
    fun getMachineExtension(argument: suspend GetMachineExtensionPlainArgsBuilder.() -> Unit):
        GetMachineExtensionResult {
        val builder = GetMachineExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachineExtensionResultToKotlin(getMachineExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get a run command.
     * Azure REST API version: 2023-10-03-preview.
     * @param argument null
     * @return Describes a Run Command
     */
    public suspend fun getMachineRunCommand(argument: GetMachineRunCommandPlainArgs):
        GetMachineRunCommandResult =
        getMachineRunCommandResultToKotlin(getMachineRunCommandPlain(argument.toJava()).await())

    /**
     * @see [getMachineRunCommand].
     * @param machineName The name of the hybrid machine.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param runCommandName The name of the run command.
     * @return Describes a Run Command
     */
    public suspend fun getMachineRunCommand(
        machineName: String,
        resourceGroupName: String,
        runCommandName: String,
    ): GetMachineRunCommandResult {
        val argument = GetMachineRunCommandPlainArgs(
            machineName = machineName,
            resourceGroupName = resourceGroupName,
            runCommandName = runCommandName,
        )
        return getMachineRunCommandResultToKotlin(getMachineRunCommandPlain(argument.toJava()).await())
    }

    /**
     * @see [getMachineRunCommand].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcompute&#46;kotlin&#46;inputs&#46;GetMachineRunCommandPlainArgs].
     * @return Describes a Run Command
     */
    public suspend
    fun getMachineRunCommand(argument: suspend GetMachineRunCommandPlainArgsBuilder.() -> Unit):
        GetMachineRunCommandResult {
        val builder = GetMachineRunCommandPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachineRunCommandResultToKotlin(getMachineRunCommandPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2022-12-27.
     * Other available API versions: 2020-08-15-preview, 2023-06-20-preview, 2023-10-03-preview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scopeName The name of the Azure Arc PrivateLinkScope resource.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        scopeName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            scopeName = scopeName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcompute&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a Azure Arc PrivateLinkScope.
     * Azure REST API version: 2022-12-27.
     * Other available API versions: 2020-08-15-preview, 2023-06-20-preview, 2023-10-03-preview.
     * @param argument null
     * @return An Azure Arc PrivateLinkScope definition.
     */
    public suspend fun getPrivateLinkScope(argument: GetPrivateLinkScopePlainArgs):
        GetPrivateLinkScopeResult =
        getPrivateLinkScopeResultToKotlin(getPrivateLinkScopePlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkScope].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scopeName The name of the Azure Arc PrivateLinkScope resource.
     * @return An Azure Arc PrivateLinkScope definition.
     */
    public suspend fun getPrivateLinkScope(resourceGroupName: String, scopeName: String):
        GetPrivateLinkScopeResult {
        val argument = GetPrivateLinkScopePlainArgs(
            resourceGroupName = resourceGroupName,
            scopeName = scopeName,
        )
        return getPrivateLinkScopeResultToKotlin(getPrivateLinkScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcompute&#46;kotlin&#46;inputs&#46;GetPrivateLinkScopePlainArgs].
     * @return An Azure Arc PrivateLinkScope definition.
     */
    public suspend
    fun getPrivateLinkScope(argument: suspend GetPrivateLinkScopePlainArgsBuilder.() -> Unit):
        GetPrivateLinkScopeResult {
        val builder = GetPrivateLinkScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkScopeResultToKotlin(getPrivateLinkScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a scoped resource in a private link scope.
     * Azure REST API version: 2020-08-15-preview.
     * @param argument null
     * @return A private link scoped resource
     */
    public suspend fun getPrivateLinkScopedResource(argument: GetPrivateLinkScopedResourcePlainArgs):
        GetPrivateLinkScopedResourceResult =
        getPrivateLinkScopedResourceResultToKotlin(getPrivateLinkScopedResourcePlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkScopedResource].
     * @param name The name of the scoped resource object.
     * @param resourceGroupName The name of the resource group.
     * @param scopeName The name of the Azure Arc PrivateLinkScope resource.
     * @return A private link scoped resource
     */
    public suspend fun getPrivateLinkScopedResource(
        name: String,
        resourceGroupName: String,
        scopeName: String,
    ): GetPrivateLinkScopedResourceResult {
        val argument = GetPrivateLinkScopedResourcePlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            scopeName = scopeName,
        )
        return getPrivateLinkScopedResourceResultToKotlin(getPrivateLinkScopedResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkScopedResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcompute&#46;kotlin&#46;inputs&#46;GetPrivateLinkScopedResourcePlainArgs].
     * @return A private link scoped resource
     */
    public suspend
    fun getPrivateLinkScopedResource(argument: suspend GetPrivateLinkScopedResourcePlainArgsBuilder.() -> Unit):
        GetPrivateLinkScopedResourceResult {
        val builder = GetPrivateLinkScopedResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkScopedResourceResultToKotlin(getPrivateLinkScopedResourcePlain(builtArgument.toJava()).await())
    }
}
