@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.MachineExtensionArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.MachineExtensionPropertiesArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.MachineExtensionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Machine Extension.
 * Azure REST API version: 2022-12-27. Prior API version in Azure Native 1.x: 2020-08-02.
 * Other available API versions: 2019-08-02-preview, 2020-08-15-preview, 2022-05-10-preview, 2023-06-20-preview, 2023-10-03-preview.
 * ## Example Usage
 * ### Create or Update a Machine Extension
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineExtension = new AzureNative.HybridCompute.MachineExtension("machineExtension", new()
 *     {
 *         ExtensionName = "CustomScriptExtension",
 *         Location = "eastus2euap",
 *         MachineName = "myMachine",
 *         Properties = new AzureNative.HybridCompute.Inputs.MachineExtensionPropertiesArgs
 *         {
 *             Publisher = "Microsoft.Compute",
 *             Settings =
 *             {
 *                 { "commandToExecute", "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\"" },
 *             },
 *             Type = "CustomScriptExtension",
 *             TypeHandlerVersion = "1.10",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewMachineExtension(ctx, "machineExtension", &hybridcompute.MachineExtensionArgs{
 * 			ExtensionName: pulumi.String("CustomScriptExtension"),
 * 			Location:      pulumi.String("eastus2euap"),
 * 			MachineName:   pulumi.String("myMachine"),
 * 			Properties: &hybridcompute.MachineExtensionPropertiesArgs{
 * 				Publisher: pulumi.String("Microsoft.Compute"),
 * 				Settings: pulumi.Any{
 * 					CommandToExecute: "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\"",
 * 				},
 * 				Type:               pulumi.String("CustomScriptExtension"),
 * 				TypeHandlerVersion: pulumi.String("1.10"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.MachineExtension;
 * import com.pulumi.azurenative.hybridcompute.MachineExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineExtension = new MachineExtension("machineExtension", MachineExtensionArgs.builder()
 *             .extensionName("CustomScriptExtension")
 *             .location("eastus2euap")
 *             .machineName("myMachine")
 *             .properties(Map.ofEntries(
 *                 Map.entry("publisher", "Microsoft.Compute"),
 *                 Map.entry("settings", Map.of("commandToExecute", "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\"")),
 *                 Map.entry("type", "CustomScriptExtension"),
 *                 Map.entry("typeHandlerVersion", "1.10")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:MachineExtension CustomScriptExtension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/extensions/{extensionName}
 * ```
 * @property extensionName The name of the machine extension.
 * @property location The geo-location where the resource lives
 * @property machineName The name of the machine where the extension should be created or updated.
 * @property properties Describes Machine Extension Properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class MachineExtensionArgs(
    public val extensionName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val machineName: Output<String>? = null,
    public val properties: Output<MachineExtensionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.MachineExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.MachineExtensionArgs =
        com.pulumi.azurenative.hybridcompute.MachineExtensionArgs.builder()
            .extensionName(extensionName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .machineName(machineName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MachineExtensionArgs].
 */
@PulumiTagMarker
public class MachineExtensionArgsBuilder internal constructor() {
    private var extensionName: Output<String>? = null

    private var location: Output<String>? = null

    private var machineName: Output<String>? = null

    private var properties: Output<MachineExtensionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("opkrnnpbuklabioh")
    public suspend fun extensionName(`value`: Output<String>) {
        this.extensionName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gchxkslmdojrbdvd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the machine where the extension should be created or updated.
     */
    @JvmName("iofnxgmmavpanexe")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value Describes Machine Extension Properties.
     */
    @JvmName("gaaaxejprnvuvgtl")
    public suspend fun properties(`value`: Output<MachineExtensionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jtwqatkgisarxltk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rfhmwmyuybiicibr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("vlaatseyqnygssxi")
    public suspend fun extensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xeusmwwjhpfrjudx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the machine where the extension should be created or updated.
     */
    @JvmName("svxqkiovxtekfbap")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value Describes Machine Extension Properties.
     */
    @JvmName("juvcotmombnrvpwk")
    public suspend fun properties(`value`: MachineExtensionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Describes Machine Extension Properties.
     */
    @JvmName("hotckfubnkfpxyte")
    public suspend
    fun properties(argument: suspend MachineExtensionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MachineExtensionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fmadxiuoxqnlscfj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rrtboarxpphyldjv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vaislcaummaciswl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MachineExtensionArgs = MachineExtensionArgs(
        extensionName = extensionName,
        location = location,
        machineName = machineName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
