@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.PrivateLinkScopedResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A private link scoped resource
 * Azure REST API version: 2020-08-15-preview. Prior API version in Azure Native 1.x: 2020-08-15-preview.
 * ## Example Usage
 * ### Update a scoped resource in a private link scope.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScopedResource = new AzureNative.HybridCompute.PrivateLinkScopedResource("privateLinkScopedResource", new()
 *     {
 *         LinkedResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/Machines/machineName1",
 *         Name = "scoped-resource-name",
 *         ResourceGroupName = "myResourceGroup",
 *         ScopeName = "myPrivateLinkScope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewPrivateLinkScopedResource(ctx, "privateLinkScopedResource", &hybridcompute.PrivateLinkScopedResourceArgs{
 * 			LinkedResourceId:  pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/Machines/machineName1"),
 * 			Name:              pulumi.String("scoped-resource-name"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ScopeName:         pulumi.String("myPrivateLinkScope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScopedResource;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScopedResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScopedResource = new PrivateLinkScopedResource("privateLinkScopedResource", PrivateLinkScopedResourceArgs.builder()
 *             .linkedResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/Machines/machineName1")
 *             .name("scoped-resource-name")
 *             .resourceGroupName("myResourceGroup")
 *             .scopeName("myPrivateLinkScope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:PrivateLinkScopedResource scoped-resource-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/privateLinkScopes/{scopeName}/scopedResources/{name}
 * ```
 * @property linkedResourceId The resource id of the scoped Azure monitor resource.
 * @property name The name of the scoped resource object.
 * @property resourceGroupName The name of the resource group.
 * @property scopeName The name of the Azure Arc PrivateLinkScope resource.
 */
public data class PrivateLinkScopedResourceArgs(
    public val linkedResourceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.PrivateLinkScopedResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.PrivateLinkScopedResourceArgs =
        com.pulumi.azurenative.hybridcompute.PrivateLinkScopedResourceArgs.builder()
            .linkedResourceId(linkedResourceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopeName(scopeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkScopedResourceArgs].
 */
@PulumiTagMarker
public class PrivateLinkScopedResourceArgsBuilder internal constructor() {
    private var linkedResourceId: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopeName: Output<String>? = null

    /**
     * @param value The resource id of the scoped Azure monitor resource.
     */
    @JvmName("rfnivfgqsqmevtnr")
    public suspend fun linkedResourceId(`value`: Output<String>) {
        this.linkedResourceId = value
    }

    /**
     * @param value The name of the scoped resource object.
     */
    @JvmName("ghujqdgpepyivdol")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ijrlwabacxyocwix")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure Arc PrivateLinkScope resource.
     */
    @JvmName("odyyyjubaouktjvo")
    public suspend fun scopeName(`value`: Output<String>) {
        this.scopeName = value
    }

    /**
     * @param value The resource id of the scoped Azure monitor resource.
     */
    @JvmName("udnbbnmiuwownyca")
    public suspend fun linkedResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedResourceId = mapped
    }

    /**
     * @param value The name of the scoped resource object.
     */
    @JvmName("xsjhkigquhrhxmmg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("relxsqktibsdtugf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Arc PrivateLinkScope resource.
     */
    @JvmName("ktubdkleowsxttls")
    public suspend fun scopeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeName = mapped
    }

    internal fun build(): PrivateLinkScopedResourceArgs = PrivateLinkScopedResourceArgs(
        linkedResourceId = linkedResourceId,
        name = name,
        resourceGroupName = resourceGroupName,
        scopeName = scopeName,
    )
}
