@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.GetMachineRunCommandPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property machineName The name of the hybrid machine.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property runCommandName The name of the run command.
 */
public data class GetMachineRunCommandPlainArgs(
    public val machineName: String,
    public val resourceGroupName: String,
    public val runCommandName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.GetMachineRunCommandPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.GetMachineRunCommandPlainArgs =
        com.pulumi.azurenative.hybridcompute.inputs.GetMachineRunCommandPlainArgs.builder()
            .machineName(machineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .runCommandName(runCommandName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMachineRunCommandPlainArgs].
 */
@PulumiTagMarker
public class GetMachineRunCommandPlainArgsBuilder internal constructor() {
    private var machineName: String? = null

    private var resourceGroupName: String? = null

    private var runCommandName: String? = null

    /**
     * @param value The name of the hybrid machine.
     */
    @JvmName("ifuktbfdmoflhqlb")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.machineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dwknuewtckgoblit")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the run command.
     */
    @JvmName("hbewjjaqdwqfamrq")
    public suspend fun runCommandName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.runCommandName = mapped
    }

    internal fun build(): GetMachineRunCommandPlainArgs = GetMachineRunCommandPlainArgs(
        machineName = machineName ?: throw PulumiNullFieldException("machineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        runCommandName = runCommandName ?: throw PulumiNullFieldException("runCommandName"),
    )
}
