@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Instance view status.
 * @property code The status code.
 * @property displayStatus The short localizable label for the status.
 * @property level The level code.
 * @property message The detailed status message, including for alerts and error messages.
 * @property time The time of the status.
 */
public data class ExtensionsResourceStatusResponse(
    public val code: String? = null,
    public val displayStatus: String? = null,
    public val level: String? = null,
    public val message: String? = null,
    public val time: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.ExtensionsResourceStatusResponse):
            ExtensionsResourceStatusResponse = ExtensionsResourceStatusResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            displayStatus = javaType.displayStatus().map({ args0 -> args0 }).orElse(null),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            time = javaType.time().map({ args0 -> args0 }).orElse(null),
        )
    }
}
