@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An Azure Arc PrivateLinkScope definition.
 * @property id Azure resource Id
 * @property location Resource location
 * @property name Azure resource name
 * @property properties Properties that define a Azure Arc PrivateLinkScope resource.
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags
 * @property type Azure resource type
 */
public data class GetPrivateLinkScopeResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: HybridComputePrivateLinkScopePropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.GetPrivateLinkScopeResult):
            GetPrivateLinkScopeResult = GetPrivateLinkScopeResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.hybridcompute.kotlin.outputs.HybridComputePrivateLinkScopePropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
