@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of a License.
 * @property assignedLicenses Describes the number of assigned licenses.
 * @property edition Describes the edition of the license. The values are either Standard or Datacenter.
 * @property immutableId Describes the immutable id.
 * @property processors Describes the number of processors.
 * @property state Describes the state of the license.
 * @property target Describes the license target server.
 * @property type Describes the license core type (pCore or vCore).
 */
public data class LicenseDetailsResponse(
    public val assignedLicenses: Int,
    public val edition: String? = null,
    public val immutableId: String,
    public val processors: Int? = null,
    public val state: String? = null,
    public val target: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.LicenseDetailsResponse):
            LicenseDetailsResponse = LicenseDetailsResponse(
            assignedLicenses = javaType.assignedLicenses(),
            edition = javaType.edition().map({ args0 -> args0 }).orElse(null),
            immutableId = javaType.immutableId(),
            processors = javaType.processors().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
