@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.inputs

import com.pulumi.azurenative.hybridconnectivity.inputs.EndpointPropertiesArgs.builder
import com.pulumi.azurenative.hybridconnectivity.kotlin.enums.Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Endpoint details
 * @property resourceId The resource Id of the connectivity endpoint (optional).
 * @property type The type of endpoint.
 */
public data class EndpointPropertiesArgs(
    public val resourceId: Output<String>? = null,
    public val type: Output<Either<String, Type>>,
) : ConvertibleToJava<com.pulumi.azurenative.hybridconnectivity.inputs.EndpointPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridconnectivity.inputs.EndpointPropertiesArgs =
        com.pulumi.azurenative.hybridconnectivity.inputs.EndpointPropertiesArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EndpointPropertiesArgs].
 */
@PulumiTagMarker
public class EndpointPropertiesArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var type: Output<Either<String, Type>>? = null

    /**
     * @param value The resource Id of the connectivity endpoint (optional).
     */
    @JvmName("pektsumsihvugwfc")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The type of endpoint.
     */
    @JvmName("tfhlintycnglgppi")
    public suspend fun type(`value`: Output<Either<String, Type>>) {
        this.type = value
    }

    /**
     * @param value The resource Id of the connectivity endpoint (optional).
     */
    @JvmName("jajyeugwftghnkmi")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The type of endpoint.
     */
    @JvmName("cdhegxwxydmhwltu")
    public suspend fun type(`value`: Either<String, Type>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of endpoint.
     */
    @JvmName("ppwbckeqijiaygfw")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of endpoint.
     */
    @JvmName("kmbgwrvkljjhrcpr")
    public fun type(`value`: Type) {
        val toBeMapped = Either.ofRight<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EndpointPropertiesArgs = EndpointPropertiesArgs(
        resourceId = resourceId,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
