@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.inputs

import com.pulumi.azurenative.hybridconnectivity.inputs.ListEndpointManagedProxyDetailsPlainArgs.builder
import com.pulumi.azurenative.hybridconnectivity.kotlin.enums.ServiceName
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName The endpoint name.
 * @property hostname The target host name.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
 * @property service The name of the service.
 * @property serviceName The name of the service. It is an optional property, if not provided, service configuration tokens issue code would be by passed.
 */
public data class ListEndpointManagedProxyDetailsPlainArgs(
    public val endpointName: String,
    public val hostname: String? = null,
    public val resourceUri: String,
    public val service: String,
    public val serviceName: Either<String, ServiceName>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridconnectivity.inputs.ListEndpointManagedProxyDetailsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridconnectivity.inputs.ListEndpointManagedProxyDetailsPlainArgs =
        com.pulumi.azurenative.hybridconnectivity.inputs.ListEndpointManagedProxyDetailsPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .hostname(hostname?.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 }))
            .service(service.let({ args0 -> args0 }))
            .serviceName(
                serviceName?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ListEndpointManagedProxyDetailsPlainArgs].
 */
@PulumiTagMarker
public class ListEndpointManagedProxyDetailsPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var hostname: String? = null

    private var resourceUri: String? = null

    private var service: String? = null

    private var serviceName: Either<String, ServiceName>? = null

    /**
     * @param value The endpoint name.
     */
    @JvmName("agqahuyoxolskwjr")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value The target host name.
     */
    @JvmName("hgvcymgfknqbbqxs")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostname = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("atowcxmxbimntaks")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    /**
     * @param value The name of the service.
     */
    @JvmName("yggucqnmwooxanmi")
    public suspend fun service(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.service = mapped
    }

    /**
     * @param value The name of the service. It is an optional property, if not provided, service configuration tokens issue code would be by passed.
     */
    @JvmName("ybhayggewcamsygj")
    public suspend fun serviceName(`value`: Either<String, ServiceName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the service. It is an optional property, if not provided, service configuration tokens issue code would be by passed.
     */
    @JvmName("xrqpjikjgxehvixn")
    public fun serviceName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceName>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the service. It is an optional property, if not provided, service configuration tokens issue code would be by passed.
     */
    @JvmName("uwsopnnqhyluyoxc")
    public fun serviceName(`value`: ServiceName) {
        val toBeMapped = Either.ofRight<String, ServiceName>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): ListEndpointManagedProxyDetailsPlainArgs =
        ListEndpointManagedProxyDetailsPlainArgs(
            endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
            hostname = hostname,
            resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
            service = service ?: throw PulumiNullFieldException("service"),
            serviceName = serviceName,
        )
}
