@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The ingress gateway access credentials
 * @property accessKey Access key for hybrid connection.
 * @property expiresOn The expiration of access key in unix time.
 * @property hostname The ingress hostname.
 * @property hybridConnectionName Azure Relay hybrid connection name for the resource.
 * @property namespaceName The namespace name.
 * @property namespaceNameSuffix The suffix domain name of relay namespace.
 * @property serverId The arc ingress gateway server app id.
 * @property serviceConfigurationToken The token to access the enabled service.
 * @property tenantId The target resource home tenant id.
 */
public data class ListEndpointIngressGatewayCredentialsResult(
    public val accessKey: String,
    public val expiresOn: Double? = null,
    public val hostname: String,
    public val hybridConnectionName: String,
    public val namespaceName: String,
    public val namespaceNameSuffix: String,
    public val serverId: String,
    public val serviceConfigurationToken: String? = null,
    public val tenantId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridconnectivity.outputs.ListEndpointIngressGatewayCredentialsResult):
            ListEndpointIngressGatewayCredentialsResult = ListEndpointIngressGatewayCredentialsResult(
            accessKey = javaType.accessKey(),
            expiresOn = javaType.expiresOn().map({ args0 -> args0 }).orElse(null),
            hostname = javaType.hostname(),
            hybridConnectionName = javaType.hybridConnectionName(),
            namespaceName = javaType.namespaceName(),
            namespaceNameSuffix = javaType.namespaceNameSuffix(),
            serverId = javaType.serverId(),
            serviceConfigurationToken = javaType.serviceConfigurationToken().map({ args0 ->
                args0
            }).orElse(null),
            tenantId = javaType.tenantId(),
        )
    }
}
