@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.AgentPoolArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.enums.Mode
import com.pulumi.azurenative.hybridcontainerservice.kotlin.enums.OsType
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.AgentPoolExtendedLocationArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.AgentPoolExtendedLocationArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.AgentPoolProvisioningStatusStatusArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.AgentPoolProvisioningStatusStatusArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.CloudProviderProfileArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.CloudProviderProfileArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The agentPool resource definition
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * ## Example Usage
 * ### PutAgentPool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.HybridContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "test-hybridaksnodepool",
 *         Count = 1,
 *         Location = "westus",
 *         OsType = "Linux",
 *         ResourceGroupName = "test-arcappliance-resgrp",
 *         ResourceName = "test-hybridakscluster",
 *         VmSize = "Standard_A4_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewAgentPool(ctx, "agentPool", &hybridcontainerservice.AgentPoolArgs{
 * 			AgentPoolName:     pulumi.String("test-hybridaksnodepool"),
 * 			Count:             pulumi.Int(1),
 * 			Location:          pulumi.String("westus"),
 * 			OsType:            pulumi.String("Linux"),
 * 			ResourceGroupName: pulumi.String("test-arcappliance-resgrp"),
 * 			ResourceName:      pulumi.String("test-hybridakscluster"),
 * 			VmSize:            pulumi.String("Standard_A4_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.AgentPool;
 * import com.pulumi.azurenative.hybridcontainerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("test-hybridaksnodepool")
 *             .count(1)
 *             .location("westus")
 *             .osType("Linux")
 *             .resourceGroupName("test-arcappliance-resgrp")
 *             .resourceName("test-hybridakscluster")
 *             .vmSize("Standard_A4_v2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:AgentPool test-hybridaksnodepool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{resourceName}/agentPools/{agentPoolName}
 * ```
 * @property agentPoolName Parameter for the name of the agent pool in the provisioned cluster
 * @property availabilityZones AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
 * @property cloudProviderProfile The underlying cloud infra provider properties.
 * @property count Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
 * @property extendedLocation
 * @property location The resource location
 * @property maxCount The maximum number of nodes for auto-scaling
 * @property maxPods The maximum number of pods that can run on a node.
 * @property minCount The minimum number of nodes for auto-scaling
 * @property mode Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
 * @property nodeImageVersion The version of node image
 * @property nodeLabels NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
 * @property nodeTaints NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
 * @property osType OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Parameter for the name of the provisioned cluster
 * @property status HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
 * @property tags Resource tags
 * @property vmSize VmSize - The size of the agent pool VMs.
 */
public data class AgentPoolArgs(
    public val agentPoolName: Output<String>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val cloudProviderProfile: Output<CloudProviderProfileArgs>? = null,
    public val count: Output<Int>? = null,
    public val extendedLocation: Output<AgentPoolExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val maxCount: Output<Int>? = null,
    public val maxPods: Output<Int>? = null,
    public val minCount: Output<Int>? = null,
    public val mode: Output<Either<String, Mode>>? = null,
    public val nodeImageVersion: Output<String>? = null,
    public val nodeLabels: Output<Map<String, String>>? = null,
    public val nodeTaints: Output<List<String>>? = null,
    public val osType: Output<Either<String, OsType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val status: Output<AgentPoolProvisioningStatusStatusArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vmSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.AgentPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.AgentPoolArgs =
        com.pulumi.azurenative.hybridcontainerservice.AgentPoolArgs.builder()
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cloudProviderProfile(
                cloudProviderProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .count(count?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maxCount(maxCount?.applyValue({ args0 -> args0 }))
            .maxPods(maxPods?.applyValue({ args0 -> args0 }))
            .minCount(minCount?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nodeImageVersion(nodeImageVersion?.applyValue({ args0 -> args0 }))
            .nodeLabels(
                nodeLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .nodeTaints(nodeTaints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vmSize(vmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentPoolArgs].
 */
@PulumiTagMarker
public class AgentPoolArgsBuilder internal constructor() {
    private var agentPoolName: Output<String>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var cloudProviderProfile: Output<CloudProviderProfileArgs>? = null

    private var count: Output<Int>? = null

    private var extendedLocation: Output<AgentPoolExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var maxCount: Output<Int>? = null

    private var maxPods: Output<Int>? = null

    private var minCount: Output<Int>? = null

    private var mode: Output<Either<String, Mode>>? = null

    private var nodeImageVersion: Output<String>? = null

    private var nodeLabels: Output<Map<String, String>>? = null

    private var nodeTaints: Output<List<String>>? = null

    private var osType: Output<Either<String, OsType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var status: Output<AgentPoolProvisioningStatusStatusArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vmSize: Output<String>? = null

    /**
     * @param value Parameter for the name of the agent pool in the provisioned cluster
     */
    @JvmName("erkgkisbsdalxoms")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
     */
    @JvmName("ydhjdtcrcwjgxore")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("myienvbosvyuookb")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
     */
    @JvmName("trngpulkqtiohoil")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The underlying cloud infra provider properties.
     */
    @JvmName("csontvojhkhcwqtt")
    public suspend fun cloudProviderProfile(`value`: Output<CloudProviderProfileArgs>) {
        this.cloudProviderProfile = value
    }

    /**
     * @param value Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
     */
    @JvmName("aqyqxnufkurvkvnl")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value
     */
    @JvmName("wyfvfjntdbmetsah")
    public suspend fun extendedLocation(`value`: Output<AgentPoolExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The resource location
     */
    @JvmName("pxonwvtpbavkigxo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The maximum number of nodes for auto-scaling
     */
    @JvmName("acomjdkxutyrgadd")
    public suspend fun maxCount(`value`: Output<Int>) {
        this.maxCount = value
    }

    /**
     * @param value The maximum number of pods that can run on a node.
     */
    @JvmName("geloywmpfimpymym")
    public suspend fun maxPods(`value`: Output<Int>) {
        this.maxPods = value
    }

    /**
     * @param value The minimum number of nodes for auto-scaling
     */
    @JvmName("qxqjhyyytwnrtffb")
    public suspend fun minCount(`value`: Output<Int>) {
        this.minCount = value
    }

    /**
     * @param value Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
     */
    @JvmName("drwufliusjwrlbjx")
    public suspend fun mode(`value`: Output<Either<String, Mode>>) {
        this.mode = value
    }

    /**
     * @param value The version of node image
     */
    @JvmName("hsaquidjhjkqrbvw")
    public suspend fun nodeImageVersion(`value`: Output<String>) {
        this.nodeImageVersion = value
    }

    /**
     * @param value NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
     */
    @JvmName("bkvvlehqrjogiuhw")
    public suspend fun nodeLabels(`value`: Output<Map<String, String>>) {
        this.nodeLabels = value
    }

    /**
     * @param value NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("ttcimlnfjrmodkgj")
    public suspend fun nodeTaints(`value`: Output<List<String>>) {
        this.nodeTaints = value
    }

    @JvmName("mjdvdiolfjrxyykd")
    public suspend fun nodeTaints(vararg values: Output<String>) {
        this.nodeTaints = Output.all(values.asList())
    }

    /**
     * @param values NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("lmrfmshcmmylbqpp")
    public suspend fun nodeTaints(values: List<Output<String>>) {
        this.nodeTaints = Output.all(values)
    }

    /**
     * @param value OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
     */
    @JvmName("otwkaflkclgcujgt")
    public suspend fun osType(`value`: Output<Either<String, OsType>>) {
        this.osType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qkujilsilqcmoufy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parameter for the name of the provisioned cluster
     */
    @JvmName("unhfpdaroevqkhue")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
     */
    @JvmName("eeiyrrpnxrtiopvf")
    public suspend fun status(`value`: Output<AgentPoolProvisioningStatusStatusArgs>) {
        this.status = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("eoehjntwsxwaesuv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VmSize - The size of the agent pool VMs.
     */
    @JvmName("xyknofrycyflksiw")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value Parameter for the name of the agent pool in the provisioned cluster
     */
    @JvmName("haemgutgdnuycqyi")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
     */
    @JvmName("hxbnxadrbiotakui")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
     */
    @JvmName("jdeyybdvbmgkwoks")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The underlying cloud infra provider properties.
     */
    @JvmName("jfxihmopghshdikn")
    public suspend fun cloudProviderProfile(`value`: CloudProviderProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudProviderProfile = mapped
    }

    /**
     * @param argument The underlying cloud infra provider properties.
     */
    @JvmName("rnmqhevtjynhksbp")
    public suspend
    fun cloudProviderProfile(argument: suspend CloudProviderProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudProviderProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloudProviderProfile = mapped
    }

    /**
     * @param value Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
     */
    @JvmName("tlybivsomderoseg")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value
     */
    @JvmName("vvaguxtersydtvoa")
    public suspend fun extendedLocation(`value`: AgentPoolExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rrdulvllwbkdbjke")
    public suspend
    fun extendedLocation(argument: suspend AgentPoolExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPoolExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The resource location
     */
    @JvmName("xclqbaagjieryncd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The maximum number of nodes for auto-scaling
     */
    @JvmName("eqgwufywlsbivsrr")
    public suspend fun maxCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCount = mapped
    }

    /**
     * @param value The maximum number of pods that can run on a node.
     */
    @JvmName("evwiyebxamvkujdk")
    public suspend fun maxPods(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPods = mapped
    }

    /**
     * @param value The minimum number of nodes for auto-scaling
     */
    @JvmName("ellhbwctqnchmrak")
    public suspend fun minCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCount = mapped
    }

    /**
     * @param value Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
     */
    @JvmName("tutfsdguqmdyaiye")
    public suspend fun mode(`value`: Either<String, Mode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
     */
    @JvmName("lnrgpyfrhpsjkowf")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
     */
    @JvmName("axihqooqbkpfaqgc")
    public fun mode(`value`: Mode) {
        val toBeMapped = Either.ofRight<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The version of node image
     */
    @JvmName("sninfefktpktsuyc")
    public suspend fun nodeImageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeImageVersion = mapped
    }

    /**
     * @param value NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
     */
    @JvmName("njvniyklujxfemoi")
    public suspend fun nodeLabels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeLabels = mapped
    }

    /**
     * @param values NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
     */
    @JvmName("ieylfltublcwvcxu")
    public fun nodeLabels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeLabels = mapped
    }

    /**
     * @param value NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("benysevfugeduwyp")
    public suspend fun nodeTaints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeTaints = mapped
    }

    /**
     * @param values NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("gufpewpgequgbnly")
    public suspend fun nodeTaints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeTaints = mapped
    }

    /**
     * @param value OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
     */
    @JvmName("rnmkniiwpydwderg")
    public suspend fun osType(`value`: Either<String, OsType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
     */
    @JvmName("bbhiasvruajhttcu")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
     */
    @JvmName("biviqaqjalwhnron")
    public fun osType(`value`: OsType) {
        val toBeMapped = Either.ofRight<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kcnrfopqryueofgf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameter for the name of the provisioned cluster
     */
    @JvmName("tfpggmmciohnuadx")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
     */
    @JvmName("hbqhkmycvocuyltx")
    public suspend fun status(`value`: AgentPoolProvisioningStatusStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param argument HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
     */
    @JvmName("wkxslcuruogxbjyg")
    public suspend
    fun status(argument: suspend AgentPoolProvisioningStatusStatusArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPoolProvisioningStatusStatusArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.status = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qcooadttuuclqeig")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("dspntkyetgvkwnqw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VmSize - The size of the agent pool VMs.
     */
    @JvmName("kmywpxnabmwxyoae")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): AgentPoolArgs = AgentPoolArgs(
        agentPoolName = agentPoolName,
        availabilityZones = availabilityZones,
        cloudProviderProfile = cloudProviderProfile,
        count = count,
        extendedLocation = extendedLocation,
        location = location,
        maxCount = maxCount,
        maxPods = maxPods,
        minCount = minCount,
        mode = mode,
        nodeImageVersion = nodeImageVersion,
        nodeLabels = nodeLabels,
        nodeTaints = nodeTaints,
        osType = osType,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        status = status,
        tags = tags,
        vmSize = vmSize,
    )
}
