@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults to Enabled.
 */
public enum class AutoUpgradeOptions(
    public val javaValue: com.pulumi.azurenative.hybridcontainerservice.enums.AutoUpgradeOptions,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.enums.AutoUpgradeOptions> {
    Enabled(com.pulumi.azurenative.hybridcontainerservice.enums.AutoUpgradeOptions.Enabled),
    Disabled(com.pulumi.azurenative.hybridcontainerservice.enums.AutoUpgradeOptions.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.enums.AutoUpgradeOptions =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.enums.AutoUpgradeOptions):
            AutoUpgradeOptions = AutoUpgradeOptions.values().first { it.javaValue == javaType }
    }
}
